"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves the identifiers of all of the HSMs provisioned for the current customer. This operation supports pagination with the use of the NextToken member. If more results are available, the NextToken member of the response contains a token that you pass in the next call to ListHsms to retrieve the next set of items.

    Args:
        next_token(str, optional): The NextToken value from a previous call to ListHsms. Pass null if this is the first call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hsms.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hsms.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="list_hsms",
        op_kwargs={"NextToken": next_token},
    )
