"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    subnet_id: str,
    ssh_key: str,
    iam_role_arn: str,
    subscription_type: str,
    eni_ip: str = None,
    external_id: str = None,
    client_token: str = None,
    syslog_ip: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Creates an uninitialized HSM instance. There is an upfront fee charged for each HSM instance that you create with the CreateHsm operation. If you accidentally provision an HSM and want to request a refund, delete the instance using the DeleteHsm operation, go to the AWS Support Center, create a new case, and select Account and Billing Support.  It can take up to 20 minutes to create and provision an HSM. You can monitor the status of the HSM with the DescribeHsm operation. The HSM is ready to be initialized when the status changes to RUNNING.

    Args:
        subnet_id(str): The identifier of the subnet in your VPC in which to place the HSM.
        ssh_key(str): The SSH public key to install on the HSM.
        eni_ip(str, optional): The IP address to assign to the HSM's ENI. If an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the subnet. Defaults to None.
        iam_role_arn(str): The ARN of an IAM role to enable the AWS CloudHSM service to allocate an ENI on your behalf.
        external_id(str, optional): The external ID from IamRoleArn, if present. Defaults to None.
        subscription_type(str): Specifies the type of subscription for the HSM.    PRODUCTION - The HSM is being used in a production environment.    TRIAL - The HSM is being used in a product trial.  .
        client_token(str, optional): A user-defined token to ensure idempotence. Subsequent calls to this operation with the same token will be ignored. Defaults to None.
        syslog_ip(str, optional): The IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hsm.create(
                ctx, subnet_id=value, ssh_key=value, iam_role_arn=value, subscription_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hsm.create subnet_id=value, ssh_key=value, iam_role_arn=value, subscription_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="create_hsm",
        op_kwargs={
            "SubnetId": subnet_id,
            "SshKey": ssh_key,
            "EniIp": eni_ip,
            "IamRoleArn": iam_role_arn,
            "ExternalId": external_id,
            "SubscriptionType": subscription_type,
            "ClientToken": client_token,
            "SyslogIp": syslog_ip,
        },
    )


async def delete(hub, ctx, hsm_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Deletes an HSM. After completion, this operation cannot be undone and your key material cannot be recovered.

    Args:
        hsm_arn(str): The ARN of the HSM to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hsm.delete(ctx, hsm_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hsm.delete hsm_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="delete_hsm",
        op_kwargs={"HsmArn": hsm_arn},
    )


async def describe(
    hub, ctx, hsm_arn: str = None, hsm_serial_number: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves information about an HSM. You can identify the HSM by its ARN or its serial number.

    Args:
        hsm_arn(str, optional): The ARN of the HSM. Either the HsmArn or the SerialNumber parameter must be specified. Defaults to None.
        hsm_serial_number(str, optional): The serial number of the HSM. Either the HsmArn or the HsmSerialNumber parameter must be specified. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hsm.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hsm.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="describe_hsm",
        op_kwargs={"HsmArn": hsm_arn, "HsmSerialNumber": hsm_serial_number},
    )


async def modify(
    hub,
    ctx,
    hsm_arn: str,
    subnet_id: str = None,
    eni_ip: str = None,
    iam_role_arn: str = None,
    external_id: str = None,
    syslog_ip: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Modifies an HSM.  This operation can result in the HSM being offline for up to 15 minutes while the AWS CloudHSM service is reconfigured. If you are modifying a production HSM, you should ensure that your AWS CloudHSM service is configured for high availability, and consider executing this operation during a maintenance window.

    Args:
        hsm_arn(str): The ARN of the HSM to modify.
        subnet_id(str, optional): The new identifier of the subnet that the HSM is in. The new subnet must be in the same Availability Zone as the current subnet. Defaults to None.
        eni_ip(str, optional): The new IP address for the elastic network interface (ENI) attached to the HSM. If the HSM is moved to a different subnet, and an IP address is not specified, an IP address will be randomly chosen from the CIDR range of the new subnet. Defaults to None.
        iam_role_arn(str, optional): The new IAM role ARN. Defaults to None.
        external_id(str, optional): The new external ID. Defaults to None.
        syslog_ip(str, optional): The new IP address for the syslog monitoring server. The AWS CloudHSM service only supports one syslog monitoring server. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hsm.modify(ctx, hsm_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hsm.modify hsm_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="modify_hsm",
        op_kwargs={
            "HsmArn": hsm_arn,
            "SubnetId": subnet_id,
            "EniIp": eni_ip,
            "IamRoleArn": iam_role_arn,
            "ExternalId": external_id,
            "SyslogIp": syslog_ip,
        },
    )
