"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, label: str) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Creates a high-availability partition group. A high-availability partition group is a group of partitions that spans multiple physical HSMs.

    Args:
        label(str): The label of the new high-availability partition group.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hapg.create(ctx, label=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hapg.create label=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="create_hapg",
        op_kwargs={"Label": label},
    )


async def delete(hub, ctx, hapg_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Deletes a high-availability partition group.

    Args:
        hapg_arn(str): The ARN of the high-availability partition group to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hapg.delete(ctx, hapg_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hapg.delete hapg_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="delete_hapg",
        op_kwargs={"HapgArn": hapg_arn},
    )


async def describe(hub, ctx, hapg_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves information about a high-availability partition group.

    Args:
        hapg_arn(str): The ARN of the high-availability partition group to describe.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hapg.describe(ctx, hapg_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hapg.describe hapg_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="describe_hapg",
        op_kwargs={"HapgArn": hapg_arn},
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Lists the high-availability partition groups for the account. This operation supports pagination with the use of the NextToken member. If more results are available, the NextToken member of the response contains a token that you pass in the next call to ListHapgs to retrieve the next set of items.

    Args:
        next_token(str, optional): The NextToken value from a previous call to ListHapgs. Pass null if this is the first call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hapg.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hapg.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="list_hapgs",
        op_kwargs={"NextToken": next_token},
    )


async def modify(
    hub, ctx, hapg_arn: str, label: str = None, partition_serial_list: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Modifies an existing high-availability partition group.

    Args:
        hapg_arn(str): The ARN of the high-availability partition group to modify.
        label(str, optional): The new label for the high-availability partition group. Defaults to None.
        partition_serial_list(List, optional): The list of partition serial numbers to make members of the high-availability partition group. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.hapg.modify(ctx, hapg_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.hapg.modify hapg_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="modify_hapg",
        op_kwargs={
            "HapgArn": hapg_arn,
            "Label": label,
            "PartitionSerialList": partition_serial_list,
        },
    )
