"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx, client_arn: str, client_version: str, hapg_list: List) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Gets the configuration files necessary to connect to all high availability partition groups the client is associated with.

    Args:
        client_arn(str): The ARN of the client.
        client_version(str): The client version.
        hapg_list(List): A list of ARNs that identify the high-availability partition groups that are associated with the client.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.config.get(
                ctx, client_arn=value, client_version=value, hapg_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.config.get client_arn=value, client_version=value, hapg_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="get_config",
        op_kwargs={
            "ClientArn": client_arn,
            "ClientVersion": client_version,
            "HapgList": hapg_list,
        },
    )
