"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(hub, ctx, resource: str) -> Dict:
    r"""
    **Autogenerated function**

    List tags for a CloudFront resource.

    Args:
        resource(str):  An ARN of a CloudFront resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.tags_for_resource.list(ctx, resource=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.tags_for_resource.list resource=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_tags_for_resource",
        op_kwargs={"Resource": resource},
    )
