"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create_multiple(
    hub, ctx, streaming_distribution_config_with_tags: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on December 31, 2020. For more information, read the announcement on the Amazon CloudFront discussion forum.

    Args:
        streaming_distribution_config_with_tags(Dict):  The streaming distribution's configuration information. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.streaming_distribution.with_tag.create_multiple(
                ctx, streaming_distribution_config_with_tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.streaming_distribution.with_tag.create_multiple streaming_distribution_config_with_tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_streaming_distribution_with_tags",
        op_kwargs={
            "StreamingDistributionConfigWithTags": streaming_distribution_config_with_tags
        },
    )
