"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def tag(hub, ctx, resource: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    Add tags to a CloudFront resource.

    Args:
        resource(str):  An ARN of a CloudFront resource.
        tags(Dict):  A complex type that contains zero or more Tag elements.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.resource.tag(ctx, resource=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.resource.tag resource=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="tag_resource",
        op_kwargs={"Resource": resource, "Tags": tags},
    )


async def untag(hub, ctx, resource: str, tag_keys: Dict) -> None:
    r"""
    **Autogenerated function**

    Remove tags from a CloudFront resource.

    Args:
        resource(str):  An ARN of a CloudFront resource.
        tag_keys(Dict):  A complex type that contains zero or more Tag key elements.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.resource.untag(ctx, resource=value, tag_keys=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.resource.untag resource=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="untag_resource",
        op_kwargs={"Resource": resource, "TagKeys": tag_keys},
    )
