"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, end_points: List, fields: List, name: str, sampling_rate: int
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a real-time log configuration. After you create a real-time log configuration, you can attach it to one or more cache behaviors to send real-time log data to the specified Amazon Kinesis data stream. For more information about real-time log configurations, see Real-time logs in the Amazon CloudFront Developer Guide.

    Args:
        end_points(List): Contains information about the Amazon Kinesis data stream where you are sending real-time log data.
        fields(List): A list of fields to include in each real-time log record. For more information about fields, see Real-time log configuration fields in the Amazon CloudFront Developer Guide.
        name(str): A unique name to identify this real-time log configuration.
        sampling_rate(int): The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.realtime_log_config.create(
                ctx, end_points=value, fields=value, name=value, sampling_rate=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.realtime_log_config.create end_points=value, fields=value, name=value, sampling_rate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_realtime_log_config",
        op_kwargs={
            "EndPoints": end_points,
            "Fields": fields,
            "Name": name,
            "SamplingRate": sampling_rate,
        },
    )


async def delete(hub, ctx, name: str = None, arn: str = None) -> None:
    r"""
    **Autogenerated function**

    Deletes a real-time log configuration. You cannot delete a real-time log configuration if it’s attached to a cache behavior. First update your distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log configuration. To delete a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to delete.

    Args:
        name(str, optional): The name of the real-time log configuration to delete. Defaults to None.
        arn(str, optional): The Amazon Resource Name (ARN) of the real-time log configuration to delete. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.realtime_log_config.delete(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.realtime_log_config.delete
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_realtime_log_config",
        op_kwargs={"Name": name, "ARN": arn},
    )


async def get(hub, ctx, name: str = None, arn: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a real-time log configuration. To get a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to get.

    Args:
        name(str, optional): The name of the real-time log configuration to get. Defaults to None.
        arn(str, optional): The Amazon Resource Name (ARN) of the real-time log configuration to get. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.realtime_log_config.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.realtime_log_config.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_realtime_log_config",
        op_kwargs={"Name": name, "ARN": arn},
    )


async def list_all(hub, ctx, max_items: str = None, marker: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of real-time log configurations. You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the NextMarker value from the current response as the Marker value in the subsequent request.

    Args:
        max_items(str, optional): The maximum number of real-time log configurations that you want in the response. Defaults to None.
        marker(str, optional): Use this field when paginating results to indicate where to begin in your list of real-time log configurations. The response includes real-time log configurations in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of NextMarker from the current page’s response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.realtime_log_config.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.realtime_log_config.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_realtime_log_configs",
        op_kwargs={"MaxItems": max_items, "Marker": marker},
    )


async def update(
    hub,
    ctx,
    end_points: List = None,
    fields: List = None,
    name: str = None,
    arn: str = None,
    sampling_rate: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a real-time log configuration. When you update a real-time log configuration, all the parameters are updated with the values provided in the request. You cannot update some parameters independent of others. To update a real-time log configuration:   Call GetRealtimeLogConfig to get the current real-time log configuration.   Locally modify the parameters in the real-time log configuration that you want to update.   Call this API (UpdateRealtimeLogConfig) by providing the entire real-time log configuration, including the parameters that you modified and those that you didn’t.   You cannot update a real-time log configuration’s Name or ARN.

    Args:
        end_points(List, optional): Contains information about the Amazon Kinesis data stream where you are sending real-time log data. Defaults to None.
        fields(List, optional): A list of fields to include in each real-time log record. For more information about fields, see Real-time log configuration fields in the Amazon CloudFront Developer Guide. Defaults to None.
        name(str, optional): The name for this real-time log configuration. Defaults to None.
        arn(str, optional): The Amazon Resource Name (ARN) for this real-time log configuration. Defaults to None.
        sampling_rate(int, optional): The sampling rate for this real-time log configuration. The sampling rate determines the percentage of viewer requests that are represented in the real-time log data. You must provide an integer between 1 and 100, inclusive. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.realtime_log_config.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.realtime_log_config.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="update_realtime_log_config",
        op_kwargs={
            "EndPoints": end_points,
            "Fields": fields,
            "Name": name,
            "ARN": arn,
            "SamplingRate": sampling_rate,
        },
    )
