"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, public_key_config: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Uploads a public key to CloudFront that you can use with signed URLs and signed cookies, or with field-level encryption.

    Args:
        public_key_config(Dict): A CloudFront public key configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.public_key.init.create(ctx, public_key_config=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.public_key.init.create public_key_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_public_key",
        op_kwargs={"PublicKeyConfig": public_key_config},
    )


async def delete(hub, ctx, id_: str, if_match: str = None) -> None:
    r"""
    **Autogenerated function**

    Remove a public key you previously added to CloudFront.

    Args:
        id_(str): The ID of the public key you want to remove from CloudFront.
        if_match(str, optional): The value of the ETag header that you received when retrieving the public key identity to delete. For example: E2QWRUHAPOMQZL. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.public_key.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.public_key.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_public_key",
        op_kwargs={"Id": id_, "IfMatch": if_match},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a public key.

    Args:
        id_(str): The identifier of the public key you are getting.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.public_key.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.public_key.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_public_key",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, marker: str = None, max_items: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List all public keys that have been added to CloudFront for this account.

    Args:
        marker(str, optional): Use this when paginating results to indicate where to begin in your list of public keys. The results include public keys in the list that occur after the marker. To get the next page of results, set the Marker to the value of the NextMarker from the current page's response (which is also the ID of the last public key on that page). . Defaults to None.
        max_items(str, optional): The maximum number of public keys you want in the response body. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.public_key.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.public_key.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_public_keys",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub, ctx, public_key_config: Dict, id_: str, if_match: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Update public key information. Note that the only value you can change is the comment.

    Args:
        public_key_config(Dict): A public key configuration.
        id_(str): The identifier of the public key that you are updating.
        if_match(str, optional): The value of the ETag header that you received when retrieving the public key to update. For example: E2QWRUHAPOMQZL. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.public_key.init.update(
                ctx, public_key_config=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.public_key.init.update public_key_config=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="update_public_key",
        op_kwargs={
            "PublicKeyConfig": public_key_config,
            "Id": id_,
            "IfMatch": if_match,
        },
    )
