"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, distribution_id: str, monitoring_subscription: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an additional cost. For more information, see Viewing additional CloudFront distribution metrics in the Amazon CloudFront Developer Guide.

    Args:
        distribution_id(str): The ID of the distribution that you are enabling metrics for.
        monitoring_subscription(Dict): A monitoring subscription. This structure contains information about whether additional CloudWatch metrics are enabled for a given CloudFront distribution.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.monitoring_subscription.create(
                ctx, distribution_id=value, monitoring_subscription=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.monitoring_subscription.create distribution_id=value, monitoring_subscription=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_monitoring_subscription",
        op_kwargs={
            "DistributionId": distribution_id,
            "MonitoringSubscription": monitoring_subscription,
        },
    )


async def delete(hub, ctx, distribution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Disables additional CloudWatch metrics for the specified CloudFront distribution.

    Args:
        distribution_id(str): The ID of the distribution that you are disabling metrics for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.monitoring_subscription.delete(
                ctx, distribution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.monitoring_subscription.delete distribution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_monitoring_subscription",
        op_kwargs={"DistributionId": distribution_id},
    )


async def get(hub, ctx, distribution_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront distribution.

    Args:
        distribution_id(str): The ID of the distribution that you are getting metrics information for.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.monitoring_subscription.get(
                ctx, distribution_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.monitoring_subscription.get distribution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_monitoring_subscription",
        op_kwargs={"DistributionId": distribution_id},
    )
