"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, distribution_id: str, invalidation_batch: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Create a new invalidation.

    Args:
        distribution_id(str): The distribution's id.
        invalidation_batch(Dict): The batch information for the invalidation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.invalidation.create(
                ctx, distribution_id=value, invalidation_batch=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.invalidation.create distribution_id=value, invalidation_batch=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_invalidation",
        op_kwargs={
            "DistributionId": distribution_id,
            "InvalidationBatch": invalidation_batch,
        },
    )


async def get(hub, ctx, distribution_id: str, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the information about an invalidation.

    Args:
        distribution_id(str): The distribution's ID.
        id_(str): The identifier for the invalidation request, for example, IDFDVBD632BHDS5.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.invalidation.get(
                ctx, distribution_id=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.invalidation.get distribution_id=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_invalidation",
        op_kwargs={"DistributionId": distribution_id, "Id": id_},
    )


async def list_all(
    hub, ctx, distribution_id: str, marker: str = None, max_items: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Lists invalidation batches.

    Args:
        distribution_id(str): The distribution's ID.
        marker(str, optional): Use this parameter when paginating results to indicate where to begin in your list of invalidation batches. Because the results are returned in decreasing order from most recent to oldest, the most recent results are on the first page, the second page will contain earlier results, and so on. To get the next page of results, set Marker to the value of the NextMarker from the current page's response. This value is the same as the ID of the last invalidation batch on that page. . Defaults to None.
        max_items(str, optional): The maximum number of invalidation batches that you want in the response body. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.invalidation.list_all(ctx, distribution_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.invalidation.list_all distribution_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_invalidations",
        op_kwargs={
            "DistributionId": distribution_id,
            "Marker": marker,
            "MaxItems": max_items,
        },
    )
