"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, name: str, function_config: Dict, function_code: bytes
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a CloudFront function. To create a function, you provide the function code and some configuration information about the function. The response contains an Amazon Resource Name (ARN) that uniquely identifies the function. When you create a function, it’s in the DEVELOPMENT stage. In this stage, you can test the function with TestFunction, and update it with UpdateFunction. When you’re ready to use your function with a CloudFront distribution, use PublishFunction to copy the function from the DEVELOPMENT stage to LIVE. When it’s live, you can attach the function to a distribution’s cache behavior, using the function’s ARN.

    Args:
        name(str): A name to identify the function.
        function_config(Dict): Configuration information about the function, including an optional comment and the function’s runtime.
        function_code(bytes): The function code. For more information about writing a CloudFront function, see Writing function code for CloudFront Functions in the Amazon CloudFront Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.create(
                ctx, name=value, function_config=value, function_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.create name=value, function_config=value, function_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_function",
        op_kwargs={
            "Name": name,
            "FunctionConfig": function_config,
            "FunctionCode": function_code,
        },
    )


async def delete(hub, ctx, name: str, if_match: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a CloudFront function. You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove the function association from all cache behaviors, then delete the function. To delete a function, you must provide the function’s name and version (ETag value). To get these values, you can use ListFunctions and DescribeFunction.

    Args:
        name(str): The name of the function that you are deleting.
        if_match(str): The current version (ETag value) of the function that you are deleting, which you can get using DescribeFunction.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.delete(ctx, name=value, if_match=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.delete name=value, if_match=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_function",
        op_kwargs={"Name": name, "IfMatch": if_match},
    )


async def describe(hub, ctx, name: str, stage: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets configuration information and metadata about a CloudFront function, but not the function’s code. To get a function’s code, use GetFunction. To get configuration information and metadata about a function, you must provide the function’s name and stage. To get these values, you can use ListFunctions.

    Args:
        name(str): The name of the function that you are getting information about.
        stage(str, optional): The function’s stage, either DEVELOPMENT or LIVE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.describe(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.describe name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="describe_function",
        op_kwargs={"Name": name, "Stage": stage},
    )


async def get(hub, ctx, name: str, stage: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the code of a CloudFront function. To get configuration information and metadata about a function, use DescribeFunction. To get a function’s code, you must provide the function’s name and stage. To get these values, you can use ListFunctions.

    Args:
        name(str): The name of the function whose code you are getting.
        stage(str, optional): The function’s stage, either DEVELOPMENT or LIVE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_function",
        op_kwargs={"Name": name, "Stage": stage},
    )


async def list_all(
    hub, ctx, marker: str = None, max_items: str = None, stage: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of all CloudFront functions in your account. You can optionally apply a filter to return only the functions that are in the specified stage, either DEVELOPMENT or LIVE. You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the NextMarker value from the current response as the Marker value in the subsequent request.

    Args:
        marker(str, optional): Use this field when paginating results to indicate where to begin in your list of functions. The response includes functions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of NextMarker from the current page’s response. Defaults to None.
        max_items(str, optional): The maximum number of functions that you want in the response. Defaults to None.
        stage(str, optional): An optional filter to return only the functions that are in the specified stage, either DEVELOPMENT or LIVE. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_functions",
        op_kwargs={"Marker": marker, "MaxItems": max_items, "Stage": stage},
    )


async def publish(hub, ctx, name: str, if_match: str) -> Dict:
    r"""
    **Autogenerated function**

    Publishes a CloudFront function by copying the function code from the DEVELOPMENT stage to LIVE. This automatically updates all cache behaviors that are using this function to use the newly published copy in the LIVE stage. When a function is published to the LIVE stage, you can attach the function to a distribution’s cache behavior, using the function’s Amazon Resource Name (ARN). To publish a function, you must provide the function’s name and version (ETag value). To get these values, you can use ListFunctions and DescribeFunction.

    Args:
        name(str): The name of the function that you are publishing.
        if_match(str): The current version (ETag value) of the function that you are publishing, which you can get using DescribeFunction.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.publish(ctx, name=value, if_match=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.publish name=value, if_match=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="publish_function",
        op_kwargs={"Name": name, "IfMatch": if_match},
    )


async def test(
    hub, ctx, name: str, if_match: str, event_object: bytes, stage: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Tests a CloudFront function. To test a function, you provide an event object that represents an HTTP request or response that your CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object that you provided, and returns the function’s result (the modified event object) in the response. The response also contains function logs and error messages, if any exist. For more information about testing functions, see Testing functions in the Amazon CloudFront Developer Guide. To test a function, you provide the function’s name and version (ETag value) along with the event object. To get the function’s name and version, you can use ListFunctions and DescribeFunction.

    Args:
        name(str): The name of the function that you are testing.
        if_match(str): The current version (ETag value) of the function that you are testing, which you can get using DescribeFunction.
        stage(str, optional): The stage of the function that you are testing, either DEVELOPMENT or LIVE. Defaults to None.
        event_object(bytes): The event object to test the function with. For more information about the structure of the event object, see Testing functions in the Amazon CloudFront Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.test(
                ctx, name=value, if_match=value, event_object=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.test name=value, if_match=value, event_object=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="test_function",
        op_kwargs={
            "Name": name,
            "IfMatch": if_match,
            "Stage": stage,
            "EventObject": event_object,
        },
    )


async def update(
    hub, ctx, name: str, if_match: str, function_config: Dict, function_code: bytes
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a CloudFront function. You can update a function’s code or the comment that describes the function. You cannot update a function’s name. To update a function, you provide the function’s name and version (ETag value) along with the updated function code. To get the name and version, you can use ListFunctions and DescribeFunction.

    Args:
        name(str): The name of the function that you are updating.
        if_match(str): The current version (ETag value) of the function that you are updating, which you can get using DescribeFunction.
        function_config(Dict): Configuration information about the function.
        function_code(bytes): The function code. For more information about writing a CloudFront function, see Writing function code for CloudFront Functions in the Amazon CloudFront Developer Guide.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.function.update(
                ctx, name=value, if_match=value, function_config=value, function_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.function.update name=value, if_match=value, function_config=value, function_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="update_function",
        op_kwargs={
            "Name": name,
            "IfMatch": if_match,
            "FunctionConfig": function_config,
            "FunctionCode": function_code,
        },
    )
