"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, field_level_encryption_profile_config: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Create a field-level encryption profile.

    Args:
        field_level_encryption_profile_config(Dict): The request to create a field-level encryption profile.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.profile.init.create(
                ctx, field_level_encryption_profile_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.profile.init.create field_level_encryption_profile_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_field_level_encryption_profile",
        op_kwargs={
            "FieldLevelEncryptionProfileConfig": field_level_encryption_profile_config
        },
    )


async def delete(hub, ctx, id_: str, if_match: str = None) -> None:
    r"""
    **Autogenerated function**

    Remove a field-level encryption profile.

    Args:
        id_(str): Request the ID of the profile you want to delete from CloudFront.
        if_match(str, optional): The value of the ETag header that you received when retrieving the profile to delete. For example: E2QWRUHAPOMQZL. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.profile.init.delete(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.profile.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_field_level_encryption_profile",
        op_kwargs={"Id": id_, "IfMatch": if_match},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the field-level encryption profile information.

    Args:
        id_(str): Get the ID for the field-level encryption profile information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.profile.init.get(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.profile.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_field_level_encryption_profile",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, marker: str = None, max_items: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Request a list of field-level encryption profiles that have been created in CloudFront for this account.

    Args:
        marker(str, optional): Use this when paginating results to indicate where to begin in your list of profiles. The results include profiles in the list that occur after the marker. To get the next page of results, set the Marker to the value of the NextMarker from the current page's response (which is also the ID of the last profile on that page). . Defaults to None.
        max_items(str, optional): The maximum number of field-level encryption profiles you want in the response body. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.profile.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.profile.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_field_level_encryption_profiles",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub,
    ctx,
    field_level_encryption_profile_config: Dict,
    id_: str,
    if_match: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update a field-level encryption profile.

    Args:
        field_level_encryption_profile_config(Dict): Request to update a field-level encryption profile. .
        id_(str): The ID of the field-level encryption profile request. .
        if_match(str, optional): The value of the ETag header that you received when retrieving the profile identity to update. For example: E2QWRUHAPOMQZL. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.profile.init.update(
                ctx, field_level_encryption_profile_config=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.profile.init.update field_level_encryption_profile_config=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="update_field_level_encryption_profile",
        op_kwargs={
            "FieldLevelEncryptionProfileConfig": field_level_encryption_profile_config,
            "Id": id_,
            "IfMatch": if_match,
        },
    )
