"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, field_level_encryption_config: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Create a new field-level encryption configuration.

    Args:
        field_level_encryption_config(Dict): The request to create a new field-level encryption configuration.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.config.create(
                ctx, field_level_encryption_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.config.create field_level_encryption_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_field_level_encryption_config",
        op_kwargs={"FieldLevelEncryptionConfig": field_level_encryption_config},
    )


async def delete(hub, ctx, id_: str, if_match: str = None) -> None:
    r"""
    **Autogenerated function**

    Remove a field-level encryption configuration.

    Args:
        id_(str): The ID of the configuration you want to delete from CloudFront.
        if_match(str, optional): The value of the ETag header that you received when retrieving the configuration identity to delete. For example: E2QWRUHAPOMQZL. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.config.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.config.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_field_level_encryption_config",
        op_kwargs={"Id": id_, "IfMatch": if_match},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the field-level encryption configuration information.

    Args:
        id_(str): Request the ID for the field-level encryption configuration information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.config.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.config.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_field_level_encryption_config",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, marker: str = None, max_items: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List all field-level encryption configurations that have been created in CloudFront for this account.

    Args:
        marker(str, optional): Use this when paginating results to indicate where to begin in your list of configurations. The results include configurations in the list that occur after the marker. To get the next page of results, set the Marker to the value of the NextMarker from the current page's response (which is also the ID of the last configuration on that page). . Defaults to None.
        max_items(str, optional): The maximum number of field-level encryption configurations you want in the response body. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.config.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.config.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_field_level_encryption_configs",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub, ctx, field_level_encryption_config: Dict, id_: str, if_match: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Update a field-level encryption configuration.

    Args:
        field_level_encryption_config(Dict): Request to update a field-level encryption configuration. .
        id_(str): The ID of the configuration you want to update.
        if_match(str, optional): The value of the ETag header that you received when retrieving the configuration identity to update. For example: E2QWRUHAPOMQZL. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.field_level_encryption.config.update(
                ctx, field_level_encryption_config=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.field_level_encryption.config.update field_level_encryption_config=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="update_field_level_encryption_config",
        op_kwargs={
            "FieldLevelEncryptionConfig": field_level_encryption_config,
            "Id": id_,
            "IfMatch": if_match,
        },
    )
