"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create_multiple(hub, ctx, distribution_config_with_tags: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Create a new distribution with tags.

    Args:
        distribution_config_with_tags(Dict): The distribution's configuration information. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.with_tag.create_multiple(
                ctx, distribution_config_with_tags=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.with_tag.create_multiple distribution_config_with_tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_distribution_with_tags",
        op_kwargs={"DistributionConfigWithTags": distribution_config_with_tags},
    )
