"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, distribution_config: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new web distribution. You create a CloudFront distribution to tell CloudFront where you want content to be delivered from, and the details about how to track and manage content delivery. Send a POST request to the /CloudFront API version/distribution/distribution ID resource.  When you update a distribution, there are more required fields than when you create a distribution. When you update your distribution by using UpdateDistribution, follow the steps included in the documentation to get the current configuration and then make your updates. This helps to make sure that you include all of the required fields. To view a summary, see Required Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.

    Args:
        distribution_config(Dict): The distribution's configuration information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.init.create(
                ctx, distribution_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.init.create distribution_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_distribution",
        op_kwargs={"DistributionConfig": distribution_config},
    )


async def delete(hub, ctx, id_: str, if_match: str = None) -> None:
    r"""
    **Autogenerated function**

    Delete a distribution.

    Args:
        id_(str): The distribution ID. .
        if_match(str, optional): The value of the ETag header that you received when you disabled the distribution. For example: E2QWRUHAPOMQZL. . Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_distribution",
        op_kwargs={"Id": id_, "IfMatch": if_match},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the information about a distribution.

    Args:
        id_(str): The distribution's ID. If the ID is empty, an empty distribution configuration is returned.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.init.get(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_distribution",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, marker: str = None, max_items: str = None) -> Dict:
    r"""
    **Autogenerated function**

    List CloudFront distributions.

    Args:
        marker(str, optional): Use this when paginating results to indicate where to begin in your list of distributions. The results include distributions in the list that occur after the marker. To get the next page of results, set the Marker to the value of the NextMarker from the current page's response (which is also the ID of the last distribution on that page). Defaults to None.
        max_items(str, optional): The maximum number of distributions you want in the response body. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_distributions",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub, ctx, distribution_config: Dict, id_: str, if_match: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the configuration for a web distribution.   When you update a distribution, there are more required fields than when you create a distribution. When you update your distribution by using this API action, follow the steps here to get the current configuration and then make your updates, to make sure that you include all of the required fields. To view a summary, see Required Fields for Create Distribution and Update Distribution in the Amazon CloudFront Developer Guide.  The update process includes getting the current distribution configuration, updating the XML document that is returned to make your changes, and then submitting an UpdateDistribution request to make the updates. For information about updating a distribution using the CloudFront console instead, see Creating a Distribution in the Amazon CloudFront Developer Guide.  To update a web distribution using the CloudFront API    Submit a GetDistributionConfig request to get the current configuration and an Etag header for the distribution.  If you update the distribution again, you must get a new Etag header.    Update the XML document that was returned in the response to your GetDistributionConfig request to include your changes.   When you edit the XML file, be aware of the following:   You must strip out the ETag parameter that is returned.   Additional fields are required when you update a distribution. There may be fields included in the XML file for features that you haven't configured for your distribution. This is expected and required to successfully update the distribution.   You can't change the value of CallerReference. If you try to change this value, CloudFront returns an IllegalUpdate error.    The new configuration replaces the existing configuration; the values that you specify in an UpdateDistribution request are not merged into your existing configuration. When you add, delete, or replace values in an element that allows multiple values (for example, CNAME), you must specify all of the values that you want to appear in the updated distribution. In addition, you must update the corresponding Quantity element.      Submit an UpdateDistribution request to update the configuration for your distribution:   In the request body, include the XML document that you updated in Step 2. The request body must include an XML document with a DistributionConfig element.   Set the value of the HTTP If-Match header to the value of the ETag header that CloudFront returned when you submitted the GetDistributionConfig request in Step 1.     Review the response to the UpdateDistribution request to confirm that the configuration was successfully updated.   Optional: Submit a GetDistribution request to confirm that your changes have propagated. When propagation is complete, the value of Status is Deployed.

    Args:
        distribution_config(Dict): The distribution's configuration information.
        id_(str): The distribution's id.
        if_match(str, optional): The value of the ETag header that you received when retrieving the distribution's configuration. For example: E2QWRUHAPOMQZL. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.init.update(
                ctx, distribution_config=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.init.update distribution_config=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="update_distribution",
        op_kwargs={
            "DistributionConfig": distribution_config,
            "Id": id_,
            "IfMatch": if_match,
        },
    )
