"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "web_acl_id"


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, web_acl_id: str, marker: str = None, max_items: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    List the distributions that are associated with a specified WAF web ACL.

    Args:
        marker(str, optional): Use Marker and MaxItems to control pagination of results. If you have more than MaxItems distributions that satisfy the request, the response includes a NextMarker element. To get the next page of results, submit another request. For the value of Marker, specify the value of NextMarker from the last response. (For the first request, omit Marker.) . Defaults to None.
        max_items(str, optional): The maximum number of distributions that you want CloudFront to return in the response body. The maximum and default values are both 100. Defaults to None.
        web_acl_id(str): The ID of the WAF web ACL that you want to list the associated distributions. If you specify "null" for the ID, the request returns a list of the distributions that aren't associated with a web ACL.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.by.web_acl_id_.list(
                ctx, web_acl_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.by.web_acl_id.list web_acl_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_distributions_by_web_acl_id",
        op_kwargs={"Marker": marker, "MaxItems": max_items, "WebACLId": web_acl_id},
    )
