"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    marker: str = None,
    max_items: str = None,
    realtime_log_config_name: str = None,
    realtime_log_config_arn: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of distributions that have a cache behavior that’s associated with the specified real-time log configuration. You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list distributions for. You can optionally specify the maximum number of items to receive in the response. If the total number of items in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the next page of items, send a subsequent request that specifies the NextMarker value from the current response as the Marker value in the subsequent request.

    Args:
        marker(str, optional): Use this field when paginating results to indicate where to begin in your list of distributions. The response includes distributions in the list that occur after the marker. To get the next page of the list, set this field’s value to the value of NextMarker from the current page’s response. Defaults to None.
        max_items(str, optional): The maximum number of distributions that you want in the response. Defaults to None.
        realtime_log_config_name(str, optional): The name of the real-time log configuration whose associated distributions you want to list. Defaults to None.
        realtime_log_config_arn(str, optional): The Amazon Resource Name (ARN) of the real-time log configuration whose associated distributions you want to list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.distribution.by.realtime_log_config.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.distribution.by.realtime_log_config.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_distributions_by_realtime_log_config",
        op_kwargs={
            "Marker": marker,
            "MaxItems": max_items,
            "RealtimeLogConfigName": realtime_log_config_name,
            "RealtimeLogConfigArn": realtime_log_config_arn,
        },
    )
