"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, cloud_front_origin_access_identity_config: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more information about how to use origin access identities, see Serving Private Content through CloudFront in the Amazon CloudFront Developer Guide.

    Args:
        cloud_front_origin_access_identity_config(Dict): The current configuration information for the identity.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.cloud_front_origin_access_identity.init.create(
                ctx, cloud_front_origin_access_identity_config=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.cloud_front_origin_access_identity.init.create cloud_front_origin_access_identity_config=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="create_cloud_front_origin_access_identity",
        op_kwargs={
            "CloudFrontOriginAccessIdentityConfig": cloud_front_origin_access_identity_config
        },
    )


async def delete(hub, ctx, id_: str, if_match: str = None) -> None:
    r"""
    **Autogenerated function**

    Delete an origin access identity.

    Args:
        id_(str): The origin access identity's ID.
        if_match(str, optional): The value of the ETag header you received from a previous GET or PUT request. For example: E2QWRUHAPOMQZL. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.cloud_front_origin_access_identity.init.delete(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.cloud_front_origin_access_identity.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="delete_cloud_front_origin_access_identity",
        op_kwargs={"Id": id_, "IfMatch": if_match},
    )


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the information about an origin access identity.

    Args:
        id_(str): The identity's ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.cloud_front_origin_access_identity.init.get(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.cloud_front_origin_access_identity.init.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_cloud_front_origin_access_identity",
        op_kwargs={"Id": id_},
    )


async def list_all(hub, ctx, marker: str = None, max_items: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists origin access identities.

    Args:
        marker(str, optional): Use this when paginating results to indicate where to begin in your list of origin access identities. The results include identities in the list that occur after the marker. To get the next page of results, set the Marker to the value of the NextMarker from the current page's response (which is also the ID of the last identity on that page). Defaults to None.
        max_items(str, optional): The maximum number of origin access identities you want in the response body. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.cloud_front_origin_access_identity.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.cloud_front_origin_access_identity.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="list_cloud_front_origin_access_identities",
        op_kwargs={"Marker": marker, "MaxItems": max_items},
    )


async def update(
    hub,
    ctx,
    cloud_front_origin_access_identity_config: Dict,
    id_: str,
    if_match: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Update an origin access identity.

    Args:
        cloud_front_origin_access_identity_config(Dict): The identity's configuration information.
        id_(str): The identity's id.
        if_match(str, optional): The value of the ETag header that you received when retrieving the identity's configuration. For example: E2QWRUHAPOMQZL. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.cloud_front_origin_access_identity.init.update(
                ctx, cloud_front_origin_access_identity_config=value, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.cloud_front_origin_access_identity.init.update cloud_front_origin_access_identity_config=value, id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="update_cloud_front_origin_access_identity",
        op_kwargs={
            "CloudFrontOriginAccessIdentityConfig": cloud_front_origin_access_identity_config,
            "Id": id_,
            "IfMatch": if_match,
        },
    )
