"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the configuration information about an origin access identity.

    Args:
        id_(str): The identity's ID. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.cloud_front_origin_access_identity.config.get(
                ctx, id_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.cloud_front_origin_access_identity.config.get id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="get_cloud_front_origin_access_identity_config",
        op_kwargs={"Id": id_},
    )
