"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def associate(hub, ctx, target_distribution_id: str, alias: str) -> None:
    r"""
    **Autogenerated function**

    Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution. With this operation you can move an alias that’s already in use on a CloudFront distribution to a different distribution in one step. This prevents the downtime that could occur if you first remove the alias from one distribution and then separately add the alias to another distribution. To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target distribution for the alias. For more information, including how to set up the target distribution, prerequisites that you must complete, and other restrictions, see Moving an alternate domain name to a different distribution in the Amazon CloudFront Developer Guide.

    Args:
        target_distribution_id(str): The ID of the distribution that you’re associating the alias with.
        alias(str): The alias (also known as a CNAME) to add to the target distribution.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudfront.alias.associate(
                ctx, target_distribution_id=value, alias=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudfront.alias.associate target_distribution_id=value, alias=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudfront",
        operation="associate_alias",
        op_kwargs={"TargetDistributionId": target_distribution_id, "Alias": alias},
    )
