"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def cancel(hub, ctx, stack_name: str, client_request_token: str = None) -> None:
    r"""
    **Autogenerated function**

    Cancels an update on the specified stack. If the call completes successfully, the stack rolls back the update and reverts to the previous stack configuration.  You can cancel only stacks that are in the UPDATE_IN_PROGRESS state.

    Args:
        stack_name(str): The name or the unique stack ID that is associated with the stack.
        client_request_token(str, optional): A unique identifier for this CancelUpdateStack request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to cancel an update on a stack with the same name. You might retry CancelUpdateStack requests to ensure that CloudFormation successfully received them. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.update.stack.cancel(ctx, stack_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.update.stack.cancel stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="cancel_update_stack",
        op_kwargs={"StackName": stack_name, "ClientRequestToken": client_request_token},
    )
