"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    type_: str = None,
    type_name: str = None,
    arn: str = None,
    max_results: int = None,
    next_token: str = None,
    deprecated_status: str = None,
    publisher_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summary information about the versions of an extension.

    Args:
        type_(str, optional): The kind of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_name(str, optional): The name of the extension for which you want version summary information. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        arn(str, optional): The Amazon Resource Name (ARN) of the extension for which you want version summary information. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. Defaults to None.
        next_token(str, optional): If the previous paginated request didn't return all of the remaining results, the response object's NextToken parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object's NextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. Defaults to None.
        deprecated_status(str, optional): The deprecation status of the extension versions that you want to get summary information about. Valid values include:    LIVE: The extension version is registered and can be used in CloudFormation operations, dependent on its provisioning behavior and visibility scope.    DEPRECATED: The extension version has been deregistered and can no longer be used in CloudFormation operations.    The default is LIVE. Defaults to None.
        publisher_id(str, optional): The publisher ID of the extension publisher. Extensions published by Amazon are not assigned a publisher ID. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.version.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.version.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_type_versions",
        op_kwargs={
            "Type": type_,
            "TypeName": type_name,
            "Arn": arn,
            "MaxResults": max_results,
            "NextToken": next_token,
            "DeprecatedStatus": deprecated_status,
            "PublisherId": publisher_id,
        },
    )
