"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(hub, ctx, registration_token: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about an extension's registration, including its current status and type and version identifiers. When you initiate a registration request using  RegisterType , you can then use  DescribeTypeRegistration  to monitor the progress of that registration request. Once the registration request has completed, use  DescribeType  to return detailed information about an extension.

    Args:
        registration_token(str): The identifier for this registration request. This registration token is generated by CloudFormation when you initiate a registration request using  RegisterType .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.registration.describe(
                ctx, registration_token=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.registration.describe registration_token=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="describe_type_registration",
        op_kwargs={"RegistrationToken": registration_token},
    )


async def list_all(
    hub,
    ctx,
    type_: str = None,
    type_name: str = None,
    type_arn: str = None,
    registration_status_filter: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of registration tokens for the specified extension(s).

    Args:
        type_(str, optional): The kind of extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_name(str, optional): The name of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_arn(str, optional): The Amazon Resource Name (ARN) of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        registration_status_filter(str, optional): The current status of the extension registration request. The default is IN_PROGRESS. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. Defaults to None.
        next_token(str, optional): If the previous paginated request didn't return all of the remaining results, the response object's NextToken parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object's NextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.registration.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.registration.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_type_registrations",
        op_kwargs={
            "Type": type_,
            "TypeName": type_name,
            "TypeArn": type_arn,
            "RegistrationStatusFilter": registration_status_filter,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
