"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def activate(
    hub,
    ctx,
    type_: str = None,
    public_type_arn: str = None,
    publisher_id: str = None,
    type_name: str = None,
    type_name_alias: str = None,
    auto_update: bool = None,
    logging_config: Dict = None,
    execution_role_arn: str = None,
    version_bump: str = None,
    major_version: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Activates a public third-party extension, making it available for use in stack templates. For more information, see Using public extensions in the CloudFormation User Guide. Once you have activated a public third-party extension in your account and region, use SetTypeConfiguration to specify configuration properties for the extension. For more information, see Configuring extensions at the account level in the CloudFormation User Guide.

    Args:
        type_(str, optional): The extension type. Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId. Defaults to None.
        public_type_arn(str, optional): The Amazon Resource Number (ARN) of the public extension. Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId. Defaults to None.
        publisher_id(str, optional): The ID of the extension publisher. Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId. Defaults to None.
        type_name(str, optional): The name of the extension. Conditional: You must specify PublicTypeArn, or TypeName, Type, and PublisherId. Defaults to None.
        type_name_alias(str, optional): An alias to assign to the public extension, in this account and region. If you specify an alias for the extension, CloudFormation treats the alias as the extension type name within this account and region. You must use the alias to refer to the extension in your templates, API calls, and CloudFormation console. An extension alias must be unique within a given account and region. You can activate the same public resource multiple times in the same account and region, using different type name aliases. Defaults to None.
        auto_update(bool, optional): Whether to automatically update the extension in this account and region when a new minor version is published by the extension publisher. Major versions released by the publisher must be manually updated. The default is true. Defaults to None.
        logging_config(Dict, optional): Contains logging configuration information for an extension. Defaults to None.
        execution_role_arn(str, optional): The name of the IAM execution role to use to activate the extension. Defaults to None.
        version_bump(str, optional): Manually updates a previously-activated type to a new major or minor version, if available. You can also use this parameter to update the value of AutoUpdate.    MAJOR: CloudFormation updates the extension to the newest major version, if one is available.    MINOR: CloudFormation updates the extension to the newest minor version, if one is available.  . Defaults to None.
        major_version(int, optional): The major version of this extension you want to activate, if multiple major versions are available. The default is the latest major version. CloudFormation uses the latest available minor version of the major version selected. You can specify MajorVersion or VersionBump, but not both. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.activate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.activate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="activate_type",
        op_kwargs={
            "Type": type_,
            "PublicTypeArn": public_type_arn,
            "PublisherId": publisher_id,
            "TypeName": type_name,
            "TypeNameAlias": type_name_alias,
            "AutoUpdate": auto_update,
            "LoggingConfig": logging_config,
            "ExecutionRoleArn": execution_role_arn,
            "VersionBump": version_bump,
            "MajorVersion": major_version,
        },
    )


async def deactivate(
    hub, ctx, type_name: str = None, type_: str = None, arn: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deactivates a public extension that was previously activated in this account and region. Once deactivated, an extension cannot be used in any CloudFormation operation. This includes stack update operations where the stack template includes the extension, even if no updates are being made to the extension. In addition, deactivated extensions are not automatically updated if a new version of the extension is released.

    Args:
        type_name(str, optional): The type name of the extension, in this account and region. If you specified a type name alias when enabling the extension, use the type name alias. Conditional: You must specify either Arn, or TypeName and Type. Defaults to None.
        type_(str, optional): The extension type. Conditional: You must specify either Arn, or TypeName and Type. Defaults to None.
        arn(str, optional): The Amazon Resource Name (ARN) for the extension, in this account and region. Conditional: You must specify either Arn, or TypeName and Type. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.deactivate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.deactivate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="deactivate_type",
        op_kwargs={"TypeName": type_name, "Type": type_, "Arn": arn},
    )


async def deregister(
    hub,
    ctx,
    arn: str = None,
    type_: str = None,
    type_name: str = None,
    version_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Marks an extension or extension version as DEPRECATED in the CloudFormation registry, removing it from active use. Deprecated extensions or extension versions cannot be used in CloudFormation operations. To deregister an entire extension, you must individually deregister all active versions of that extension. If an extension has only a single active version, deregistering that version results in the extension itself being deregistered and marked as deprecated in the registry.  You cannot deregister the default version of an extension if there are other active version of that extension. If you do deregister the default version of an extension, the textensionype itself is deregistered as well and marked as deprecated.  To view the deprecation status of an extension or extension version, use DescribeType.

    Args:
        arn(str, optional): The Amazon Resource Name (ARN) of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_(str, optional): The kind of extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_name(str, optional): The name of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        version_id(str, optional): The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it is registered. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.deregister(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.deregister
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="deregister_type",
        op_kwargs={
            "Arn": arn,
            "Type": type_,
            "TypeName": type_name,
            "VersionId": version_id,
        },
    )


async def describe(
    hub,
    ctx,
    type_: str = None,
    type_name: str = None,
    arn: str = None,
    version_id: str = None,
    publisher_id: str = None,
    public_version_number: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns detailed information about an extension that has been registered. If you specify a VersionId, DescribeType returns information about that specific extension version. Otherwise, it returns information about the default extension version.

    Args:
        type_(str, optional): The kind of extension.  Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_name(str, optional): The name of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        arn(str, optional): The Amazon Resource Name (ARN) of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        version_id(str, optional): The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it is registered. If you specify a VersionId, DescribeType returns information about that specific extension version. Otherwise, it returns information about the default extension version. Defaults to None.
        publisher_id(str, optional): The publisher ID of the extension publisher. Extensions provided by Amazon are not assigned a publisher ID. Defaults to None.
        public_version_number(str, optional): The version number of a public third-party extension. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="describe_type",
        op_kwargs={
            "Type": type_,
            "TypeName": type_name,
            "Arn": arn,
            "VersionId": version_id,
            "PublisherId": publisher_id,
            "PublicVersionNumber": public_version_number,
        },
    )


async def list_all(
    hub,
    ctx,
    visibility: str = None,
    provisioning_type: str = None,
    deprecated_status: str = None,
    type_: str = None,
    filters: Dict = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summary information about extension that have been registered with CloudFormation.

    Args:
        visibility(str, optional): The scope at which the extensions are visible and usable in CloudFormation operations. Valid values include:    PRIVATE: Extensions that are visible and usable within this account and region. This includes:   Private extensions you have registered in this account and region.   Public extensions that you have activated in this account and region.      PUBLIC: Extensions that are publicly visible and available to be activated within any Amazon account. This includes extensions from Amazon, as well as third-party publishers.   The default is PRIVATE. Defaults to None.
        provisioning_type(str, optional): For resource types, the provisioning behavior of the resource type. CloudFormation determines the provisioning type during registration, based on the types of handlers in the schema handler package submitted. Valid values include:    FULLY_MUTABLE: The resource type includes an update handler to process updates to the type during stack update operations.    IMMUTABLE: The resource type does not include an update handler, so the type cannot be updated and must instead be replaced during stack update operations.    NON_PROVISIONABLE: The resource type does not include create, read, and delete handlers, and therefore cannot actually be provisioned.   The default is FULLY_MUTABLE. Defaults to None.
        deprecated_status(str, optional): The deprecation status of the extension that you want to get summary information about. Valid values include:    LIVE: The extension is registered for use in CloudFormation operations.    DEPRECATED: The extension has been deregistered and can no longer be used in CloudFormation operations.   . Defaults to None.
        type_(str, optional): The type of extension. Defaults to None.
        filters(Dict, optional): Filter criteria to use in determining which extensions to return. If you specify a filter, CloudFormation ignores any specified Visibility value when returning the list of types. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. Defaults to None.
        next_token(str, optional): If the previous paginated request didn't return all of the remaining results, the response object's NextToken parameter value is set to a token. To retrieve the next set of results, call this action again and assign that token to the request object's NextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_types",
        op_kwargs={
            "Visibility": visibility,
            "ProvisioningType": provisioning_type,
            "DeprecatedStatus": deprecated_status,
            "Type": type_,
            "Filters": filters,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def publish(
    hub,
    ctx,
    type_: str = None,
    arn: str = None,
    type_name: str = None,
    public_version_number: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Publishes the specified extension to the CloudFormation registry as a public extension in this region. Public extensions are available for use by all CloudFormation users. For more information on publishing extensions, see Publishing extensions to make them available for public use in the CloudFormation CLI User Guide. To publish an extension, you must be registered as a publisher with CloudFormation. For more information, see RegisterPublisher.

    Args:
        type_(str, optional): The type of the extension. Conditional: You must specify Arn, or TypeName and Type. Defaults to None.
        arn(str, optional): The Amazon Resource Number (ARN) of the extension. Conditional: You must specify Arn, or TypeName and Type. Defaults to None.
        type_name(str, optional): The name of the extension. Conditional: You must specify Arn, or TypeName and Type. Defaults to None.
        public_version_number(str, optional): The version number to assign to this version of the extension. Use the following format, and adhere to semantic versioning when assigning a version number to your extension:   MAJOR.MINOR.PATCH  For more information, see Semantic Versioning 2.0.0. If you do not specify a version number, CloudFormation increments the version number by one minor version release. The first time you publish a type, CloudFormation sets the version number to 1.0.0, regardless of the value you specify. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.publish(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.publish
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="publish_type",
        op_kwargs={
            "Type": type_,
            "Arn": arn,
            "TypeName": type_name,
            "PublicVersionNumber": public_version_number,
        },
    )


async def register(
    hub,
    ctx,
    type_name: str,
    schema_handler_package: str,
    type_: str = None,
    logging_config: Dict = None,
    execution_role_arn: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Registers an extension with the CloudFormation service. Registering an extension makes it available for use in CloudFormation templates in your account, and includes:   Validating the extension schema   Determining which handlers, if any, have been specified for the extension   Making the extension available for use in your account   For more information on how to develop extensions and ready them for registeration, see Creating Resource Providers in the CloudFormation CLI User Guide. You can have a maximum of 50 resource extension versions registered at a time. This maximum is per account and per region. Use DeregisterType to deregister specific extension versions if necessary. Once you have initiated a registration request using  RegisterType , you can use  DescribeTypeRegistration  to monitor the progress of the registration request. Once you have registered a private extension in your account and region, use SetTypeConfiguration to specify configuration properties for the extension. For more information, see Configuring extensions at the account level in the CloudFormation User Guide.

    Args:
        type_(str, optional): The kind of extension. Defaults to None.
        type_name(str): The name of the extension being registered. We recommend that extension names adhere to the following patterns:    For resource types, company_or_organization::service::type.   For modules, company_or_organization::service::type::MODULE.    The following organization namespaces are reserved and cannot be used in your extension names:    Alexa     AMZN     Amazon     AWS     Custom     Dev    .
        schema_handler_package(str): A url to the S3 bucket containing the extension project package that contains the neccessary files for the extension you want to register. For information on generating a schema handler package for the extension you want to register, see submit in the CloudFormation CLI User Guide.  The user registering the extension must be able to access the package in the S3 bucket. That is, the user needs to have GetObject permissions for the schema handler package. For more information, see Actions, Resources, and Condition Keys for Amazon S3 in the Identity and Access Management User Guide. .
        logging_config(Dict, optional): Specifies logging configuration information for an extension. Defaults to None.
        execution_role_arn(str, optional): The Amazon Resource Name (ARN) of the IAM role for CloudFormation to assume when invoking the extension. For CloudFormation to assume the specified execution role, the role must contain a trust relationship with the CloudFormation service principle (resources.cloudformation.amazonaws.com). For more information on adding trust relationships, see Modifying a role trust policy in the Identity and Access Management User Guide. If your extension calls Amazon Web Services APIs in any of its handlers, you must create an  IAM execution role  that includes the necessary permissions to call those Amazon Web Services APIs, and provision that execution role in your account. When CloudFormation needs to invoke the resource type handler, CloudFormation assumes this execution role to create a temporary session token, which it then passes to the resource type handler, thereby supplying your resource type with the appropriate credentials. Defaults to None.
        client_request_token(str, optional): A unique identifier that acts as an idempotency key for this registration request. Specifying a client request token prevents CloudFormation from generating more than one version of an extension from the same registeration request, even if the request is submitted multiple times. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.register(
                ctx, type_name=value, schema_handler_package=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.register type_name=value, schema_handler_package=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="register_type",
        op_kwargs={
            "Type": type_,
            "TypeName": type_name,
            "SchemaHandlerPackage": schema_handler_package,
            "LoggingConfig": logging_config,
            "ExecutionRoleArn": execution_role_arn,
            "ClientRequestToken": client_request_token,
        },
    )


async def test(
    hub,
    ctx,
    arn: str = None,
    type_: str = None,
    type_name: str = None,
    version_id: str = None,
    log_delivery_bucket: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Tests a registered extension to make sure it meets all necessary requirements for being published in the CloudFormation registry.   For resource types, this includes passing all contracts tests defined for the type.   For modules, this includes determining if the module's model meets all necessary requirements.   For more information, see Testing your public extension prior to publishing in the CloudFormation CLI User Guide. If you do not specify a version, CloudFormation uses the default version of the extension in your account and region for testing. To perform testing, CloudFormation assumes the execution role specified when the type was registered. For more information, see RegisterType. Once you've initiated testing on an extension using TestType, you can use DescribeType to monitor the current test status and test status description for the extension. An extension must have a test status of PASSED before it can be published. For more information, see Publishing extensions to make them available for public use in the CloudFormation CLI User Guide.

    Args:
        arn(str, optional): The Amazon Resource Number (ARN) of the extension. Conditional: You must specify Arn, or TypeName and Type. Defaults to None.
        type_(str, optional): The type of the extension to test. Conditional: You must specify Arn, or TypeName and Type. Defaults to None.
        type_name(str, optional): The name of the extension to test. Conditional: You must specify Arn, or TypeName and Type. Defaults to None.
        version_id(str, optional): The version of the extension to test. You can specify the version id with either Arn, or with TypeName and Type. If you do not specify a version, CloudFormation uses the default version of the extension in this account and region for testing. Defaults to None.
        log_delivery_bucket(str, optional): The S3 bucket to which CloudFormation delivers the contract test execution logs. CloudFormation delivers the logs by the time contract testing has completed and the extension has been assigned a test type status of PASSED or FAILED. The user calling TestType must be able to access items in the specified S3 bucket. Specifically, the user needs the following permissions:   GetObject   PutObject   For more information, see Actions, Resources, and Condition Keys for Amazon S3 in the Amazon Web Services Identity and Access Management User Guide. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.init.test(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.init.test
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="test_type",
        op_kwargs={
            "Arn": arn,
            "Type": type_,
            "TypeName": type_name,
            "VersionId": version_id,
            "LogDeliveryBucket": log_delivery_bucket,
        },
    )
