"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    arn: str = None,
    type_: str = None,
    type_name: str = None,
    version_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Specify the default version of an extension. The default version of an extension will be used in CloudFormation operations.

    Args:
        arn(str, optional): The Amazon Resource Name (ARN) of the extension for which you want version summary information. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_(str, optional): The kind of extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        type_name(str, optional): The name of the extension. Conditional: You must specify either TypeName and Type, or Arn. Defaults to None.
        version_id(str, optional): The ID of a specific version of the extension. The version ID is the value at the end of the Amazon Resource Name (ARN) assigned to the extension version when it is registered. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.default_version.set(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.default_version.set
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="set_type_default_version",
        op_kwargs={
            "Arn": arn,
            "Type": type_,
            "TypeName": type_name,
            "VersionId": version_id,
        },
    )
