"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    configuration: str,
    type_arn: str = None,
    configuration_alias: str = None,
    type_name: str = None,
    type_: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Specifies the configuration data for a registered CloudFormation extension, in the given account and region. To view the current configuration data for an extension, refer to the ConfigurationSchema element of DescribeType. For more information, see Configuring extensions at the account level in the CloudFormation User Guide.  It is strongly recommended that you use dynamic references to restrict sensitive configuration definitions, such as third-party credentials. For more details on dynamic references, see Using dynamic references to specify template values in the CloudFormation User Guide.

    Args:
        type_arn(str, optional): The Amazon Resource Name (ARN) for the extension, in this account and region. For public extensions, this will be the ARN assigned when you activate the type in this account and region. For private extensions, this will be the ARN assigned when you register the type in this account and region.  Do not include the extension versions suffix at the end of the ARN. You can set the configuration for an extension, but not for a specific extension version. Defaults to None.
        configuration(str): The configuration data for the extension, in this account and region.  The configuration data must be formatted as JSON, and validate against the schema returned in the ConfigurationSchema response element of API_DescribeType. For more information, see Defining account-level configuration data for an extension in the CloudFormation CLI User Guide.
        configuration_alias(str, optional): An alias by which to refer to this extension configuration data. Conditional: Specifying a configuration alias is required when setting a configuration for a resource type extension. Defaults to None.
        type_name(str, optional): The name of the extension. Conditional: You must specify ConfigurationArn, or Type and TypeName. Defaults to None.
        type_(str, optional): The type of extension. Conditional: You must specify ConfigurationArn, or Type and TypeName. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.type_.configuration.set(ctx, configuration=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.type_.configuration.set configuration=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="set_type_configuration",
        op_kwargs={
            "TypeArn": type_arn,
            "Configuration": configuration,
            "ConfigurationAlias": configuration_alias,
            "TypeName": type_name,
            "Type": type_,
        },
    )
