"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def update(
    hub, ctx, enable_termination_protection: bool, stack_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Updates termination protection for the specified stack. If a user attempts to delete a stack with termination protection enabled, the operation fails and the stack remains unchanged. For more information, see Protecting a Stack From Being Deleted in the CloudFormation User Guide.  For nested stacks, termination protection is set on the root stack and cannot be changed directly on the nested stack.

    Args:
        enable_termination_protection(bool): Whether to enable termination protection on the specified stack.
        stack_name(str): The name or unique ID of the stack for which you want to set termination protection.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.termination_protection.update(
                ctx, enable_termination_protection=value, stack_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.termination_protection.update enable_termination_protection=value, stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="update_termination_protection",
        op_kwargs={
            "EnableTerminationProtection": enable_termination_protection,
            "StackName": stack_name,
        },
    )
