"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def estimate(
    hub,
    ctx,
    template_body: str = None,
    template_url: str = None,
    parameters: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the estimated monthly cost of a template. The return value is an Amazon Web Services Simple Monthly Calculator URL with a query string that describes the resources required to run the template.

    Args:
        template_body(str, optional): Structure containing the template body with a minimum length of 1 byte and a maximum length of 51,200 bytes. (For more information, go to Template Anatomy in the CloudFormation User Guide.) Conditional: You must pass TemplateBody or TemplateURL. If both are passed, only TemplateBody is used. Defaults to None.
        template_url(str, optional): Location of file containing the template body. The URL must point to a template that is located in an Amazon S3 bucket or a Systems Manager document. For more information, go to Template Anatomy in the CloudFormation User Guide. Conditional: You must pass TemplateURL or TemplateBody. If both are passed, only TemplateBody is used. Defaults to None.
        parameters(List, optional): A list of Parameter structures that specify input parameters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.template.cost.estimate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.template.cost.estimate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="estimate_template_cost",
        op_kwargs={
            "TemplateBody": template_body,
            "TemplateURL": template_url,
            "Parameters": parameters,
        },
    )
