"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "to_stack_set"


__func_alias__ = {"import_": "import"}


async def import_(
    hub,
    ctx,
    stack_set_name: str,
    stack_ids: List,
    operation_preferences: Dict = None,
    operation_id: str = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Import existing stacks into a new stack sets. Use the stack import operation to import up to 10 stacks into a new stack set in the same account as the source stack or in a different administrator account and Region, by specifying the stack ID of the stack you intend to import.   ImportStacksToStackSet is only supported by self-managed permissions.

    Args:
        stack_set_name(str): The name of the stack set. The name must be unique in the Region where you create your stack set.
        stack_ids(List): The IDs of the stacks you are importing into a stack set. You import up to 10 stacks per stack set at a time.
        operation_preferences(Dict, optional): The user-specified preferences for how CloudFormation performs a stack set operation.  For more information on maximum concurrent accounts and failure tolerance, see Stack set operation options. Defaults to None.
        operation_id(str, optional): A unique, user defined, identifier for the stack set operation. Defaults to None.
        call_as(str, optional): By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   For service managed stack sets, specify DELEGATED_ADMIN.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.to_stack_set_.import(ctx, stack_set_name=value, stack_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.to_stack_set.import stack_set_name=value, stack_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="import_stacks_to_stack_set",
        op_kwargs={
            "StackSetName": stack_set_name,
            "StackIds": stack_ids,
            "OperationPreferences": operation_preferences,
            "OperationId": operation_id,
            "CallAs": call_as,
        },
    )
