"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    stack_set_name: str,
    operation_id: str,
    next_token: str = None,
    max_results: int = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summary information about the results of a stack set operation.

    Args:
        stack_set_name(str): The name or unique ID of the stack set that you want to get operation results for.
        operation_id(str): The ID of the stack set operation.
        next_token(str, optional): If the previous request didn't return all of the remaining results, the response object's NextToken parameter value is set to a token. To retrieve the next set of results, call ListStackSetOperationResults again and assign that token to the request object's NextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. Defaults to None.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.set_.operation.result.list_all(
                ctx, stack_set_name=value, operation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.set_.operation.result.list_all stack_set_name=value, operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_stack_set_operation_results",
        op_kwargs={
            "StackSetName": stack_set_name,
            "OperationId": operation_id,
            "NextToken": next_token,
            "MaxResults": max_results,
            "CallAs": call_as,
        },
    )
