"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe(
    hub, ctx, stack_set_name: str, operation_id: str, call_as: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the description of the specified stack set operation.

    Args:
        stack_set_name(str): The name or the unique stack ID of the stack set for the stack operation.
        operation_id(str): The unique ID of the stack set operation. .
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.set_.operation.init.describe(
                ctx, stack_set_name=value, operation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.set_.operation.init.describe stack_set_name=value, operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="describe_stack_set_operation",
        op_kwargs={
            "StackSetName": stack_set_name,
            "OperationId": operation_id,
            "CallAs": call_as,
        },
    )


async def list_all(
    hub,
    ctx,
    stack_set_name: str,
    next_token: str = None,
    max_results: int = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summary information about operations performed on a stack set.

    Args:
        stack_set_name(str): The name or unique ID of the stack set that you want to get operation summaries for.
        next_token(str, optional): If the previous paginated request didn't return all of the remaining results, the response object's NextToken parameter value is set to a token. To retrieve the next set of results, call ListStackSetOperations again and assign that token to the request object's NextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. Defaults to None.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.set_.operation.init.list_all(
                ctx, stack_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.set_.operation.init.list_all stack_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_stack_set_operations",
        op_kwargs={
            "StackSetName": stack_set_name,
            "NextToken": next_token,
            "MaxResults": max_results,
            "CallAs": call_as,
        },
    )


async def stop(
    hub, ctx, stack_set_name: str, operation_id: str, call_as: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Stops an in-progress operation on a stack set and its associated stack instances.

    Args:
        stack_set_name(str): The name or unique ID of the stack set that you want to stop the operation for.
        operation_id(str): The ID of the stack operation. .
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.set_.operation.init.stop(
                ctx, stack_set_name=value, operation_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.set_.operation.init.stop stack_set_name=value, operation_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="stop_stack_set_operation",
        op_kwargs={
            "StackSetName": stack_set_name,
            "OperationId": operation_id,
            "CallAs": call_as,
        },
    )
