"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def detect(
    hub,
    ctx,
    stack_set_name: str,
    operation_preferences: Dict = None,
    operation_id: str = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Detect drift on a stack set. When CloudFormation performs drift detection on a stack set, it performs drift detection on the stack associated with each stack instance in the stack set. For more information, see How CloudFormation Performs Drift Detection on a Stack Set.  DetectStackSetDrift returns the OperationId of the stack set drift detection operation. Use this operation id with  DescribeStackSetOperation  to monitor the progress of the drift detection operation. The drift detection operation may take some time, depending on the number of stack instances included in the stack set, as well as the number of resources included in each stack. Once the operation has completed, use the following actions to return drift information:   Use  DescribeStackSet  to return detailed information about the stack set, including detailed information about the last completed drift operation performed on the stack set. (Information about drift operations that are in progress is not included.)   Use  ListStackInstances  to return a list of stack instances belonging to the stack set, including the drift status and last drift time checked of each instance.   Use  DescribeStackInstance  to return detailed information about a specific stack instance, including its drift status and last drift time checked.   For more information on performing a drift detection operation on a stack set, see Detecting Unmanaged Changes in Stack Sets.  You can only run a single drift detection operation on a given stack set at one time.  To stop a drift detection stack set operation, use  StopStackSetOperation .

    Args:
        stack_set_name(str): The name of the stack set on which to perform the drift detection operation.
        operation_preferences(Dict, optional): The user-specified preferences for how CloudFormation performs a stack set operation.  For more information on maximum concurrent accounts and failure tolerance, see Stack set operation options. Defaults to None.
        operation_id(str, optional):  The ID of the stack set operation. . Defaults to None.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.set_.drift.detect(
                ctx, stack_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.set_.drift.detect stack_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="detect_stack_set_drift",
        op_kwargs={
            "StackSetName": stack_set_name,
            "OperationPreferences": operation_preferences,
            "OperationId": operation_id,
            "CallAs": call_as,
        },
    )
