"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"set_": "set"}


async def get(hub, ctx, stack_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the stack policy for a specified stack. If a stack doesn't have a policy, a null value is returned.

    Args:
        stack_name(str): The name or unique stack ID that is associated with the stack whose policy you want to get.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.policy.get(ctx, stack_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.policy.get stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="get_stack_policy",
        op_kwargs={"StackName": stack_name},
    )


async def set_(
    hub,
    ctx,
    stack_name: str,
    stack_policy_body: str = None,
    stack_policy_url: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Sets a stack policy for a specified stack.

    Args:
        stack_name(str): The name or unique stack ID that you want to associate a policy with.
        stack_policy_body(str, optional): Structure containing the stack policy body. For more information, go to  Prevent Updates to Stack Resources in the CloudFormation User Guide. You can specify either the StackPolicyBody or the StackPolicyURL parameter, but not both. Defaults to None.
        stack_policy_url(str, optional): Location of a file containing the stack policy. The URL must point to a policy (maximum size: 16 KB) located in an S3 bucket in the same Region as the stack. You can specify either the StackPolicyBody or the StackPolicyURL parameter, but not both. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.policy.set(ctx, stack_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.policy.set stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="set_stack_policy",
        op_kwargs={
            "StackName": stack_name,
            "StackPolicyBody": stack_policy_body,
            "StackPolicyURL": stack_policy_url,
        },
    )
