"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create_multiple(
    hub,
    ctx,
    stack_set_name: str,
    regions: List,
    accounts: List = None,
    deployment_targets: Dict = None,
    parameter_overrides: List = None,
    operation_preferences: Dict = None,
    operation_id: str = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates stack instances for the specified accounts, within the specified Regions. A stack instance refers to a stack in a specific account and Region. You must specify at least one value for either Accounts or DeploymentTargets, and you must specify at least one value for Regions.

    Args:
        stack_set_name(str): The name or unique ID of the stack set that you want to create stack instances from.
        accounts(List, optional): [Self-managed permissions] The names of one or more accounts that you want to create stack instances in the specified Region(s) for. You can specify Accounts or DeploymentTargets, but not both. Defaults to None.
        deployment_targets(Dict, optional): [Service-managed permissions] The Organizations accounts for which to create stack instances in the specified Regions. You can specify Accounts or DeploymentTargets, but not both. Defaults to None.
        regions(List): The names of one or more Regions where you want to create stack instances using the specified accounts. .
        parameter_overrides(List, optional): A list of stack set parameters whose values you want to override in the selected stack instances. Any overridden parameter values will be applied to all stack instances in the specified accounts and Regions. When specifying parameters and their values, be aware of how CloudFormation sets parameter values during stack instance operations:   To override the current value for a parameter, include the parameter and specify its value.   To leave an overridden parameter set to its present value, include the parameter and specify UsePreviousValue as true. (You cannot specify both a value and set UsePreviousValue to true.)   To set an overridden parameter back to the value specified in the stack set, specify a parameter list but do not include the parameter in the list.   To leave all parameters set to their present values, do not specify this property at all.   During stack set updates, any parameter values overridden for a stack instance are not updated, but retain their overridden value. You can only override the parameter values that are specified in the stack set; to add or delete a parameter itself, use UpdateStackSet to update the stack set template. Defaults to None.
        operation_preferences(Dict, optional): Preferences for how CloudFormation performs this stack set operation. Defaults to None.
        operation_id(str, optional): The unique identifier for this stack set operation.  The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You might retry stack set operation requests to ensure that CloudFormation successfully received them. If you don't specify an operation ID, the SDK generates one automatically.  Repeating this stack set operation with a new operation ID retries all stack instances whose status is OUTDATED. . Defaults to None.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.instance.create_multiple(
                ctx, stack_set_name=value, regions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.instance.create_multiple stack_set_name=value, regions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="create_stack_instances",
        op_kwargs={
            "StackSetName": stack_set_name,
            "Accounts": accounts,
            "DeploymentTargets": deployment_targets,
            "Regions": regions,
            "ParameterOverrides": parameter_overrides,
            "OperationPreferences": operation_preferences,
            "OperationId": operation_id,
            "CallAs": call_as,
        },
    )


async def delete_multiple(
    hub,
    ctx,
    stack_set_name: str,
    regions: List,
    retain_stacks: bool,
    accounts: List = None,
    deployment_targets: Dict = None,
    operation_preferences: Dict = None,
    operation_id: str = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes stack instances for the specified accounts, in the specified Regions.

    Args:
        stack_set_name(str): The name or unique ID of the stack set that you want to delete stack instances for.
        accounts(List, optional): [Self-managed permissions] The names of the accounts that you want to delete stack instances for. You can specify Accounts or DeploymentTargets, but not both. Defaults to None.
        deployment_targets(Dict, optional): [Service-managed permissions] The Organizations accounts from which to delete stack instances. You can specify Accounts or DeploymentTargets, but not both. Defaults to None.
        regions(List): The Regions where you want to delete stack set instances. .
        operation_preferences(Dict, optional): Preferences for how CloudFormation performs this stack set operation. Defaults to None.
        retain_stacks(bool): Removes the stack instances from the specified stack set, but doesn't delete the stacks. You can't reassociate a retained stack or add an existing, saved stack to a new stack set. For more information, see Stack set operation options.
        operation_id(str, optional): The unique identifier for this stack set operation.  If you don't specify an operation ID, the SDK generates one automatically.  The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You can retry stack set operation requests to ensure that CloudFormation successfully received them. Repeating this stack set operation with a new operation ID retries all stack instances whose status is OUTDATED. . Defaults to None.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.instance.delete_multiple(
                ctx, stack_set_name=value, regions=value, retain_stacks=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.instance.delete_multiple stack_set_name=value, regions=value, retain_stacks=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="delete_stack_instances",
        op_kwargs={
            "StackSetName": stack_set_name,
            "Accounts": accounts,
            "DeploymentTargets": deployment_targets,
            "Regions": regions,
            "OperationPreferences": operation_preferences,
            "RetainStacks": retain_stacks,
            "OperationId": operation_id,
            "CallAs": call_as,
        },
    )


async def describe(
    hub,
    ctx,
    stack_set_name: str,
    stack_instance_account: str,
    stack_instance_region: str,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the stack instance that's associated with the specified stack set, account, and Region. For a list of stack instances that are associated with a specific stack set, use ListStackInstances.

    Args:
        stack_set_name(str): The name or the unique stack ID of the stack set that you want to get stack instance information for.
        stack_instance_account(str): The ID of an account that's associated with this stack instance.
        stack_instance_region(str): The name of a Region that's associated with this stack instance.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.instance.describe(
                ctx, stack_set_name=value, stack_instance_account=value, stack_instance_region=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.instance.describe stack_set_name=value, stack_instance_account=value, stack_instance_region=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="describe_stack_instance",
        op_kwargs={
            "StackSetName": stack_set_name,
            "StackInstanceAccount": stack_instance_account,
            "StackInstanceRegion": stack_instance_region,
            "CallAs": call_as,
        },
    )


async def list_all(
    hub,
    ctx,
    stack_set_name: str,
    next_token: str = None,
    max_results: int = None,
    filters: List = None,
    stack_instance_account: str = None,
    stack_instance_region: str = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns summary information about stack instances that are associated with the specified stack set. You can filter for stack instances that are associated with a specific account name or Region, or that have a specific status.

    Args:
        stack_set_name(str): The name or unique ID of the stack set that you want to list stack instances for.
        next_token(str, optional): If the previous request didn't return all of the remaining results, the response's NextToken parameter value is set to a token. To retrieve the next set of results, call ListStackInstances again and assign that token to the request object's NextToken parameter. If there are no remaining results, the previous response object's NextToken parameter is set to null. Defaults to None.
        max_results(int, optional): The maximum number of results to be returned with a single call. If the number of available results exceeds this maximum, the response includes a NextToken value that you can assign to the NextToken request parameter to get the next set of results. Defaults to None.
        filters(List, optional): The status that stack instances are filtered by. Defaults to None.
        stack_instance_account(str, optional): The name of the account that you want to list stack instances for. Defaults to None.
        stack_instance_region(str, optional): The name of the Region where you want to list stack instances. . Defaults to None.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.instance.list_all(
                ctx, stack_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.instance.list_all stack_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_stack_instances",
        op_kwargs={
            "StackSetName": stack_set_name,
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "StackInstanceAccount": stack_instance_account,
            "StackInstanceRegion": stack_instance_region,
            "CallAs": call_as,
        },
    )


async def update_multiple(
    hub,
    ctx,
    stack_set_name: str,
    regions: List,
    accounts: List = None,
    deployment_targets: Dict = None,
    parameter_overrides: List = None,
    operation_preferences: Dict = None,
    operation_id: str = None,
    call_as: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the parameter values for stack instances for the specified accounts, within the specified Regions. A stack instance refers to a stack in a specific account and Region.  You can only update stack instances in Regions and accounts where they already exist; to create additional stack instances, use CreateStackInstances.  During stack set updates, any parameters overridden for a stack instance are not updated, but retain their overridden value. You can only update the parameter values that are specified in the stack set; to add or delete a parameter itself, use UpdateStackSet to update the stack set template. If you add a parameter to a template, before you can override the parameter value specified in the stack set you must first use UpdateStackSet to update all stack instances with the updated template and parameter value specified in the stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter value using UpdateStackInstances.

    Args:
        stack_set_name(str): The name or unique ID of the stack set associated with the stack instances.
        accounts(List, optional): [Self-managed permissions] The names of one or more accounts for which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Regions. You can specify Accounts or DeploymentTargets, but not both. Defaults to None.
        deployment_targets(Dict, optional): [Service-managed permissions] The Organizations accounts for which you want to update parameter values for stack instances. If your update targets OUs, the overridden parameter values only apply to the accounts that are currently in the target OUs and their child OUs. Accounts added to the target OUs and their child OUs in the future won't use the overridden values. You can specify Accounts or DeploymentTargets, but not both. Defaults to None.
        regions(List): The names of one or more Regions in which you want to update parameter values for stack instances. The overridden parameter values will be applied to all stack instances in the specified accounts and Regions.
        parameter_overrides(List, optional):  A list of input parameters whose values you want to update for the specified stack instances.  Any overridden parameter values will be applied to all stack instances in the specified accounts and Regions. When specifying parameters and their values, be aware of how CloudFormation sets parameter values during stack instance update operations:   To override the current value for a parameter, include the parameter and specify its value.   To leave an overridden parameter set to its present value, include the parameter and specify UsePreviousValue as true. (You cannot specify both a value and set UsePreviousValue to true.)   To set an overridden parameter back to the value specified in the stack set, specify a parameter list but do not include the parameter in the list.   To leave all parameters set to their present values, do not specify this property at all.   During stack set updates, any parameter values overridden for a stack instance are not updated, but retain their overridden value. You can only override the parameter values that are specified in the stack set; to add or delete a parameter itself, use UpdateStackSet to update the stack set template. If you add a parameter to a template, before you can override the parameter value specified in the stack set you must first use UpdateStackSet to update all stack instances with the updated template and parameter value specified in the stack set. Once a stack instance has been updated with the new parameter, you can then override the parameter value using UpdateStackInstances. Defaults to None.
        operation_preferences(Dict, optional): Preferences for how CloudFormation performs this stack set operation. Defaults to None.
        operation_id(str, optional): The unique identifier for this stack set operation.  The operation ID also functions as an idempotency token, to ensure that CloudFormation performs the stack set operation only once, even if you retry the request multiple times. You might retry stack set operation requests to ensure that CloudFormation successfully received them. If you don't specify an operation ID, the SDK generates one automatically. . Defaults to None.
        call_as(str, optional): [Service-managed permissions] Specifies whether you are acting as an account administrator in the organization's management account or as a delegated administrator in a member account. By default, SELF is specified. Use SELF for stack sets with self-managed permissions.   If you are signed in to the management account, specify SELF.   If you are signed in to a delegated administrator account, specify DELEGATED_ADMIN. Your account must be registered as a delegated administrator in the management account. For more information, see Register a delegated administrator in the CloudFormation User Guide.  . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.stack.instance.update_multiple(
                ctx, stack_set_name=value, regions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.stack.instance.update_multiple stack_set_name=value, regions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="update_stack_instances",
        op_kwargs={
            "StackSetName": stack_set_name,
            "Accounts": accounts,
            "DeploymentTargets": deployment_targets,
            "Regions": regions,
            "ParameterOverrides": parameter_overrides,
            "OperationPreferences": operation_preferences,
            "OperationId": operation_id,
            "CallAs": call_as,
        },
    )
