"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def signal(
    hub, ctx, stack_name: str, logical_resource_id: str, unique_id: str, status: str
) -> None:
    r"""
    **Autogenerated function**

    Sends a signal to the specified resource with a success or failure status. You can use the SignalResource API in conjunction with a creation policy or update policy. CloudFormation doesn't proceed with a stack creation or update until resources receive the required number of signals or the timeout period is exceeded. The SignalResource API is useful in cases where you want to send signals from anywhere other than an Amazon EC2 instance.

    Args:
        stack_name(str): The stack name or unique stack ID that includes the resource that you want to signal.
        logical_resource_id(str): The logical ID of the resource that you want to signal. The logical ID is the name of the resource that given in the template.
        unique_id(str): A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling groups, specify the instance ID that you are signaling as the unique ID. If you send multiple signals to a single resource (such as signaling a wait condition), each signal requires a different unique ID.
        status(str): The status of the signal, which is either success or failure. A failure signal causes CloudFormation to immediately fail the stack creation or update.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.resource.signal(
                ctx, stack_name=value, logical_resource_id=value, unique_id=value, status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.resource.signal stack_name=value, logical_resource_id=value, unique_id=value, status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="signal_resource",
        op_kwargs={
            "StackName": stack_name,
            "LogicalResourceId": logical_resource_id,
            "UniqueId": unique_id,
            "Status": status,
        },
    )
