"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__virtualname__ = "import"


async def list_all(hub, ctx, export_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists all stacks that are importing an exported output value. To modify or remove an exported output value, first use this action to see which stacks are using it. To see the exported output values in your account, see ListExports.  For more information about importing an exported output value, see the  Fn::ImportValue  function.

    Args:
        export_name(str): The name of the exported output value. CloudFormation returns the stack names that are importing this value. .
        next_token(str, optional): A string (provided by the ListImports response output) that identifies the next page of stacks that are importing the specified exported output value. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.import_.list_all(ctx, export_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.import.list_all export_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_imports",
        op_kwargs={"ExportName": export_name, "NextToken": next_token},
    )
