"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def record(
    hub,
    ctx,
    bearer_token: str,
    operation_status: str,
    current_operation_status: str = None,
    status_message: str = None,
    error_code: str = None,
    resource_model: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Reports progress of a resource handler to CloudFormation. Reserved for use by the CloudFormation CLI. Do not use this API in your code.

    Args:
        bearer_token(str): Reserved for use by the CloudFormation CLI.
        operation_status(str): Reserved for use by the CloudFormation CLI.
        current_operation_status(str, optional): Reserved for use by the CloudFormation CLI. Defaults to None.
        status_message(str, optional): Reserved for use by the CloudFormation CLI. Defaults to None.
        error_code(str, optional): Reserved for use by the CloudFormation CLI. Defaults to None.
        resource_model(str, optional): Reserved for use by the CloudFormation CLI. Defaults to None.
        client_request_token(str, optional): Reserved for use by the CloudFormation CLI. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.handler_progress.record(
                ctx, bearer_token=value, operation_status=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.handler_progress.record bearer_token=value, operation_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="record_handler_progress",
        op_kwargs={
            "BearerToken": bearer_token,
            "OperationStatus": operation_status,
            "CurrentOperationStatus": current_operation_status,
            "StatusMessage": status_message,
            "ErrorCode": error_code,
            "ResourceModel": resource_model,
            "ClientRequestToken": client_request_token,
        },
    )
