"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__virtualname__ = "change_set"


async def create(
    hub,
    ctx,
    stack_name: str,
    change_set_name: str,
    template_body: str = None,
    template_url: str = None,
    use_previous_template: bool = None,
    parameters: List = None,
    capabilities: List = None,
    resource_types: List = None,
    role_arn: str = None,
    rollback_configuration: Dict = None,
    notification_ar_ns: List = None,
    tags: List = None,
    client_token: str = None,
    description: str = None,
    change_set_type: str = None,
    resources_to_import: List = None,
    include_nested_stacks: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a list of changes that will be applied to a stack so that you can review the changes before executing them. You can create a change set for a stack that doesn't exist or an existing stack. If you create a change set for a stack that doesn't exist, the change set shows all of the resources that CloudFormation will create. If you create a change set for an existing stack, CloudFormation compares the stack's information with the information that you submit in the change set and lists the differences. Use change sets to understand which resources CloudFormation will create or change, and how it will change resources in an existing stack, before you create or update a stack. To create a change set for a stack that doesn't exist, for the ChangeSetType parameter, specify CREATE. To create a change set for an existing stack, specify UPDATE for the ChangeSetType parameter. To create a change set for an import operation, specify IMPORT for the ChangeSetType parameter. After the CreateChangeSet call successfully completes, CloudFormation starts creating the change set. To check the status of the change set or to review it, use the DescribeChangeSet action. When you are satisfied with the changes the change set will make, execute the change set by using the ExecuteChangeSet action. CloudFormation doesn't make changes until you execute the change set. To create a change set for the entire stack hierachy, set IncludeNestedStacks to True.

    Args:
        stack_name(str): The name or the unique ID of the stack for which you are creating a change set. CloudFormation generates the change set by comparing this stack's information with the information that you submit, such as a modified template or different parameter input values.
        template_body(str, optional): A structure that contains the body of the revised template, with a minimum length of 1 byte and a maximum length of 51,200 bytes. CloudFormation generates the change set by comparing this template with the template of the stack that you specified. Conditional: You must specify only TemplateBody or TemplateURL. Defaults to None.
        template_url(str, optional): The location of the file that contains the revised template. The URL must point to a template (max size: 460,800 bytes) that is located in an S3 bucket or a Systems Manager document. CloudFormation generates the change set by comparing this template with the stack that you specified. Conditional: You must specify only TemplateBody or TemplateURL. Defaults to None.
        use_previous_template(bool, optional): Whether to reuse the template that is associated with the stack to create the change set. Defaults to None.
        parameters(List, optional): A list of Parameter structures that specify input parameters for the change set. For more information, see the Parameter data type. Defaults to None.
        capabilities(List, optional): In some cases, you must explicitly acknowledge that your stack template contains certain capabilities in order for CloudFormation to create the stack.    CAPABILITY_IAM and CAPABILITY_NAMED_IAM  Some stack templates might include resources that can affect permissions in your account; for example, by creating new Identity and Access Management (IAM) users. For those stacks, you must explicitly acknowledge this by specifying one of these capabilities. The following IAM resources require you to specify either the CAPABILITY_IAM or CAPABILITY_NAMED_IAM capability.   If you have IAM resources, you can specify either capability.    If you have IAM resources with custom names, you must specify CAPABILITY_NAMED_IAM.    If you don't specify either of these capabilities, CloudFormation returns an InsufficientCapabilities error.   If your stack template contains these resources, we recommend that you review all permissions associated with them and edit their permissions if necessary.     AWS::IAM::AccessKey      AWS::IAM::Group      AWS::IAM::InstanceProfile      AWS::IAM::Policy      AWS::IAM::Role      AWS::IAM::User      AWS::IAM::UserToGroupAddition    For more information, see Acknowledging IAM Resources in CloudFormation Templates.    CAPABILITY_AUTO_EXPAND  Some template contain macros. Macros perform custom processing on templates; this can include simple actions like find-and-replace operations, all the way to extensive transformations of entire templates. Because of this, users typically create a change set from the processed template, so that they can review the changes resulting from the macros before actually creating the stack. If your stack template contains one or more macros, and you choose to create a stack directly from the processed template, without first reviewing the resulting changes in a change set, you must acknowledge this capability. This includes the AWS::Include and AWS::Serverless transforms, which are macros hosted by CloudFormation.  This capacity does not apply to creating change sets, and specifying it when creating change sets has no effect. If you want to create a stack from a stack template that contains macros and nested stacks, you must create or update the stack directly from the template using the CreateStack or UpdateStack action, and specifying this capability.  For more information on macros, see Using CloudFormation Macros to Perform Custom Processing on Templates.  . Defaults to None.
        resource_types(List, optional): The template resource types that you have permissions to work with if you execute this change set, such as AWS::EC2::Instance, AWS::EC2::*, or Custom::MyCustomInstance. If the list of resource types doesn't include a resource type that you're updating, the stack update fails. By default, CloudFormation grants permissions to all resource types. Identity and Access Management (IAM) uses this parameter for condition keys in IAM policies for CloudFormation. For more information, see Controlling Access with Identity and Access Management in the CloudFormation User Guide. Defaults to None.
        role_arn(str, optional): The Amazon Resource Name (ARN) of an Identity and Access Management (IAM) role that CloudFormation assumes when executing the change set. CloudFormation uses the role's credentials to make calls on your behalf. CloudFormation uses this role for all future operations on the stack. As long as users have permission to operate on the stack, CloudFormation uses this role even if the users don't have permission to pass it. Ensure that the role grants least privilege. If you don't specify a value, CloudFormation uses the role that was previously associated with the stack. If no role is available, CloudFormation uses a temporary session that is generated from your user credentials. Defaults to None.
        rollback_configuration(Dict, optional): The rollback triggers for CloudFormation to monitor during stack creation and updating operations, and for the specified monitoring period afterwards. Defaults to None.
        notification_ar_ns(List, optional): The Amazon Resource Names (ARNs) of Amazon Simple Notification Service (Amazon SNS) topics that CloudFormation associates with the stack. To remove all associated notification topics, specify an empty list. Defaults to None.
        tags(List, optional): Key-value pairs to associate with this stack. CloudFormation also propagates these tags to resources in the stack. You can specify a maximum of 50 tags. Defaults to None.
        change_set_name(str): The name of the change set. The name must be unique among all change sets that are associated with the specified stack. A change set name can contain only alphanumeric, case sensitive characters and hyphens. It must start with an alphabetic character and cannot exceed 128 characters.
        client_token(str, optional): A unique identifier for this CreateChangeSet request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to create another change set with the same name. You might retry CreateChangeSet requests to ensure that CloudFormation successfully received them. Defaults to None.
        description(str, optional): A description to help you identify this change set. Defaults to None.
        change_set_type(str, optional): The type of change set operation. To create a change set for a new stack, specify CREATE. To create a change set for an existing stack, specify UPDATE. To create a change set for an import operation, specify IMPORT. If you create a change set for a new stack, CloudFormation creates a stack with a unique stack ID, but no template or resources. The stack will be in the  REVIEW_IN_PROGRESS  state until you execute the change set. By default, CloudFormation specifies UPDATE. You can't use the UPDATE type to create a change set for a new stack or the CREATE type to create a change set for an existing stack. Defaults to None.
        resources_to_import(List, optional): The resources to import into your stack. Defaults to None.
        include_nested_stacks(bool, optional): Creates a change set for the all nested stacks specified in the template. The default behavior of this action is set to False. To include nested sets in a change set, specify True. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.change_set_.create(
                ctx, stack_name=value, change_set_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.change_set.create stack_name=value, change_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="create_change_set",
        op_kwargs={
            "StackName": stack_name,
            "TemplateBody": template_body,
            "TemplateURL": template_url,
            "UsePreviousTemplate": use_previous_template,
            "Parameters": parameters,
            "Capabilities": capabilities,
            "ResourceTypes": resource_types,
            "RoleARN": role_arn,
            "RollbackConfiguration": rollback_configuration,
            "NotificationARNs": notification_ar_ns,
            "Tags": tags,
            "ChangeSetName": change_set_name,
            "ClientToken": client_token,
            "Description": description,
            "ChangeSetType": change_set_type,
            "ResourcesToImport": resources_to_import,
            "IncludeNestedStacks": include_nested_stacks,
        },
    )


async def delete(hub, ctx, change_set_name: str, stack_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified change set. Deleting change sets ensures that no one executes the wrong change set. If the call successfully completes, CloudFormation successfully deleted the change set. If IncludeNestedStacks specifies True during the creation of the nested change set, then DeleteChangeSet will delete all change sets that belong to the stacks hierarchy and will also delete all change sets for nested stacks with the status of REVIEW_IN_PROGRESS.

    Args:
        change_set_name(str): The name or Amazon Resource Name (ARN) of the change set that you want to delete.
        stack_name(str, optional): If you specified the name of a change set to delete, specify the stack name or ID (ARN) that is associated with it. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.change_set_.delete(ctx, change_set_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.change_set.delete change_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="delete_change_set",
        op_kwargs={"ChangeSetName": change_set_name, "StackName": stack_name},
    )


async def describe(
    hub, ctx, change_set_name: str, stack_name: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see Updating Stacks Using Change Sets in the CloudFormation User Guide.

    Args:
        change_set_name(str): The name or Amazon Resource Name (ARN) of the change set that you want to describe.
        stack_name(str, optional): If you specified the name of a change set, specify the stack name or ID (ARN) of the change set you want to describe. Defaults to None.
        next_token(str, optional): A string (provided by the DescribeChangeSet response output) that identifies the next page of information that you want to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.change_set_.describe(ctx, change_set_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.change_set.describe change_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="describe_change_set",
        op_kwargs={
            "ChangeSetName": change_set_name,
            "StackName": stack_name,
            "NextToken": next_token,
        },
    )


async def execute(
    hub,
    ctx,
    change_set_name: str,
    stack_name: str = None,
    client_request_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a stack using the input information that was provided when the specified change set was created. After the call successfully completes, CloudFormation starts updating the stack. Use the DescribeStacks action to view the status of the update. When you execute a change set, CloudFormation deletes all other change sets associated with the stack because they aren't valid for the updated stack. If a stack policy is associated with the stack, CloudFormation enforces the policy during the update. You can't specify a temporary stack policy that overrides the current policy. To create a change set for the entire stack hierachy, IncludeNestedStacks must have been set to True.

    Args:
        change_set_name(str): The name or ARN of the change set that you want use to update the specified stack.
        stack_name(str, optional): If you specified the name of a change set, specify the stack name or ID (ARN) that is associated with the change set you want to execute. Defaults to None.
        client_request_token(str, optional): A unique identifier for this ExecuteChangeSet request. Specify this token if you plan to retry requests so that CloudFormation knows that you're not attempting to execute a change set to update a stack with the same name. You might retry ExecuteChangeSet requests to ensure that CloudFormation successfully received them. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.change_set_.execute(ctx, change_set_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.change_set.execute change_set_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="execute_change_set",
        op_kwargs={
            "ChangeSetName": change_set_name,
            "StackName": stack_name,
            "ClientRequestToken": client_request_token,
        },
    )


async def list_all(hub, ctx, stack_name: str, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the ID and status of each active change set for a stack. For example, CloudFormation lists change sets that are in the CREATE_IN_PROGRESS or CREATE_PENDING state.

    Args:
        stack_name(str): The name or the Amazon Resource Name (ARN) of the stack for which you want to list change sets.
        next_token(str, optional): A string (provided by the ListChangeSets response output) that identifies the next page of change sets that you want to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudformation.change_set_.list_all(ctx, stack_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudformation.change_set.list_all stack_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudformation",
        operation="list_change_sets",
        op_kwargs={"StackName": stack_name, "NextToken": next_token},
    )
