"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def attach(
    hub,
    ctx,
    directory_arn: str,
    source_object_reference: Dict,
    target_object_reference: Dict,
    typed_link_facet: Dict,
    attributes: List,
) -> Dict:
    r"""
    **Autogenerated function**

    Attaches a typed link to a specified source and target object. For more information, see Typed Links.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) of the directory where you want to attach the typed link.
        source_object_reference(Dict): Identifies the source object that the typed link will attach to.
        target_object_reference(Dict): Identifies the target object that the typed link will attach to.
        typed_link_facet(Dict): Identifies the typed link facet that is associated with the typed link.
        attributes(List): A set of attributes that are associated with the typed link.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.typed_link.init.attach(
                ctx,
                directory_arn=value,
                source_object_reference=value,
                target_object_reference=value,
                typed_link_facet=value,
                attributes=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.typed_link.init.attach directory_arn=value, source_object_reference=value, target_object_reference=value, typed_link_facet=value, attributes=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="attach_typed_link",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "SourceObjectReference": source_object_reference,
            "TargetObjectReference": target_object_reference,
            "TypedLinkFacet": typed_link_facet,
            "Attributes": attributes,
        },
    )


async def detach(hub, ctx, directory_arn: str, typed_link_specifier: Dict) -> None:
    r"""
    **Autogenerated function**

    Detaches a typed link from a specified source and target object. For more information, see Typed Links.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) of the directory where you want to detach the typed link.
        typed_link_specifier(Dict): Used to accept a typed link specifier as input.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.typed_link.init.detach(
                ctx, directory_arn=value, typed_link_specifier=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.typed_link.init.detach directory_arn=value, typed_link_specifier=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="detach_typed_link",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "TypedLinkSpecifier": typed_link_specifier,
        },
    )
