"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, schema_arn: str, facet: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Creates a TypedLinkFacet. For more information, see Typed Links.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the schema. For more information, see arns.
        facet(Dict):  Facet structure that is associated with the typed link facet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.typed_link.facet.init.create(
                ctx, schema_arn=value, facet=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.typed_link.facet.init.create schema_arn=value, facet=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="create_typed_link_facet",
        op_kwargs={"SchemaArn": schema_arn, "Facet": facet},
    )


async def delete(hub, ctx, schema_arn: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a TypedLinkFacet. For more information, see Typed Links.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the schema. For more information, see arns.
        name(str): The unique name of the typed link facet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.typed_link.facet.init.delete(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.typed_link.facet.init.delete schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="delete_typed_link_facet",
        op_kwargs={"SchemaArn": schema_arn, "Name": name},
    )


async def update(
    hub,
    ctx,
    schema_arn: str,
    name: str,
    attribute_updates: List,
    identity_attribute_order: List,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a TypedLinkFacet. For more information, see Typed Links.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the schema. For more information, see arns.
        name(str): The unique name of the typed link facet.
        attribute_updates(List): Attributes update structure.
        identity_attribute_order(List): The order of identity attributes for the facet, from most significant to least significant. The ability to filter typed links considers the order that the attributes are defined on the typed link facet. When providing ranges to a typed link selection, any inexact ranges must be specified at the end. Any attributes that do not have a range specified are presumed to match the entire range. Filters are interpreted in the order of the attributes on the typed link facet, not the order in which they are supplied to any API calls. For more information about identity attributes, see Typed Links.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.typed_link.facet.init.update(
                ctx,
                schema_arn=value,
                name=value,
                attribute_updates=value,
                identity_attribute_order=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.typed_link.facet.init.update schema_arn=value, name=value, attribute_updates=value, identity_attribute_order=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="update_typed_link_facet",
        op_kwargs={
            "SchemaArn": schema_arn,
            "Name": name,
            "AttributeUpdates": attribute_updates,
            "IdentityAttributeOrder": identity_attribute_order,
        },
    )
