"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get_all(hub, ctx, schema_arn: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns the identity attribute order for a specific TypedLinkFacet. For more information, see Typed Links.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the schema. For more information, see arns.
        name(str): The unique name of the typed link facet.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.typed_link.facet.information.get_all(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.typed_link.facet.information.get_all schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_typed_link_facet_information",
        op_kwargs={"SchemaArn": schema_arn, "Name": name},
    )
