"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    schema_arn: str,
    name: str,
    next_token: str = None,
    max_results: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a paginated list of all attribute definitions for a particular TypedLinkFacet. For more information, see Typed Links.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) that is associated with the schema. For more information, see arns.
        name(str): The unique name of the typed link facet.
        next_token(str, optional): The pagination token. Defaults to None.
        max_results(int, optional): The maximum number of results to retrieve. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.typed_link.facet.attribute.list_all(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.typed_link.facet.attribute.list_all schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_typed_link_facet_attributes",
        op_kwargs={
            "SchemaArn": schema_arn,
            "Name": name,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
