"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def attach(
    hub, ctx, directory_arn: str, index_reference: Dict, target_reference: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Attaches the specified object to the specified index.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) of the directory where the object and index exist.
        index_reference(Dict): A reference to the index that you are attaching the object to.
        target_reference(Dict): A reference to the object that you are attaching to the index.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.to_index.attach(
                ctx, directory_arn=value, index_reference=value, target_reference=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.to_index.attach directory_arn=value, index_reference=value, target_reference=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="attach_to_index",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "IndexReference": index_reference,
            "TargetReference": target_reference,
        },
    )
