"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_arn: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per directory. All 50 tags are returned for a given directory with this API call.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the resource. Tagging is only supported for directories.
        next_token(str, optional): The pagination token. This is for future use. Currently pagination is not supported for tagging. Defaults to None.
        max_results(int, optional): The MaxResults parameter sets the maximum number of results returned in a single page. This is for future use and is not supported currently. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.tags_for_resource.list(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.tags_for_resource.list resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="list_tags_for_resource",
        op_kwargs={
            "ResourceArn": resource_arn,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
