"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def apply(hub, ctx, published_schema_arn: str, directory_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Copies the input published schema, at the specified version, into the Directory with the same name and version as that of the published schema.

    Args:
        published_schema_arn(str): Published schema Amazon Resource Name (ARN) that needs to be copied. For more information, see arns.
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory into which the schema is copied. For more information, see arns.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.schema.init.apply(
                ctx, published_schema_arn=value, directory_arn=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.schema.init.apply published_schema_arn=value, directory_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="apply_schema",
        op_kwargs={
            "PublishedSchemaArn": published_schema_arn,
            "DirectoryArn": directory_arn,
        },
    )


async def create(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new schema in a development state. A schema can exist in three phases:    Development: This is a mutable phase of the schema. All new schemas are in the development phase. Once the schema is finalized, it can be published.    Published: Published schemas are immutable and have a version associated with them.    Applied: Applied schemas are mutable in a way that allows you to add new schema facets. You can also add new, nonrequired attributes to existing schema facets. You can apply only published schemas to directories.

    Args:
        name(str): The name that is associated with the schema. This is unique to each account and in each region.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.schema.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.schema.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="create_schema",
        op_kwargs={"Name": name},
    )


async def delete(hub, ctx, schema_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a given schema. Schemas in a development and published state can only be deleted.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) of the development schema. For more information, see arns.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.schema.init.delete(ctx, schema_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.schema.init.delete schema_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="delete_schema",
        op_kwargs={"SchemaArn": schema_arn},
    )


async def publish(
    hub,
    ctx,
    development_schema_arn: str,
    version: str,
    minor_version: str = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Publishes a development schema with a major version and a recommended minor version.

    Args:
        development_schema_arn(str): The Amazon Resource Name (ARN) that is associated with the development schema. For more information, see arns.
        version(str): The major version under which the schema will be published. Schemas have both a major and minor version associated with them.
        minor_version(str, optional): The minor version under which the schema will be published. This parameter is recommended. Schemas have both a major and minor version associated with them. Defaults to None.
        name(str, optional): The new name under which the schema will be published. If this is not provided, the development schema is considered. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.schema.init.publish(
                ctx, development_schema_arn=value, version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.schema.init.publish development_schema_arn=value, version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="publish_schema",
        op_kwargs={
            "DevelopmentSchemaArn": development_schema_arn,
            "Version": version,
            "MinorVersion": minor_version,
            "Name": name,
        },
    )


async def update(hub, ctx, schema_arn: str, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Updates the schema name with a new name. Only development schema names can be updated.

    Args:
        schema_arn(str): The Amazon Resource Name (ARN) of the development schema. For more information, see arns.
        name(str): The name of the schema.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.schema.init.update(
                ctx, schema_arn=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.schema.init.update schema_arn=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="update_schema",
        op_kwargs={"SchemaArn": schema_arn, "Name": name},
    )
