"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def put(hub, ctx, schema_arn: str, document: str) -> Dict:
    r"""
    **Autogenerated function**

    Allows a schema to be updated using JSON upload. Only available for development schemas. See JSON Schema Format for more information.

    Args:
        schema_arn(str): The ARN of the schema to update.
        document(str): The replacement JSON schema.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.schema.from_json.put(
                ctx, schema_arn=value, document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.schema.from_json.put schema_arn=value, document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="put_schema_from_json",
        op_kwargs={"SchemaArn": schema_arn, "Document": document},
    )
