"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, schema_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves a JSON representation of the schema. See JSON Schema Format for more information.

    Args:
        schema_arn(str): The ARN of the schema to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.schema.as_json.get(ctx, schema_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.schema.as_json.get schema_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="get_schema_as_json",
        op_kwargs={"SchemaArn": schema_arn},
    )
