"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(
    hub, ctx, directory_arn: str, operations: List, consistency_level: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Performs all the read operations in a batch.

    Args:
        directory_arn(str): The Amazon Resource Name (ARN) that is associated with the Directory. For more information, see arns.
        operations(List): A list of operations that are part of the batch.
        consistency_level(str, optional): Represents the manner and timing in which the successful write or update of an object is reflected in a subsequent read operation of that same object. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.read.batch(
                ctx, directory_arn=value, operations=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.read.batch directory_arn=value, operations=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="batch_read",
        op_kwargs={
            "DirectoryArn": directory_arn,
            "Operations": operations,
            "ConsistencyLevel": consistency_level,
        },
    )
