"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def upgrade(
    hub,
    ctx,
    development_schema_arn: str,
    published_schema_arn: str,
    minor_version: str,
    dry_run: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Upgrades a published schema under a new minor version revision using the current contents of DevelopmentSchemaArn.

    Args:
        development_schema_arn(str): The ARN of the development schema with the changes used for the upgrade.
        published_schema_arn(str): The ARN of the published schema to be upgraded.
        minor_version(str): Identifies the minor version of the published schema that will be created. This parameter is NOT optional.
        dry_run(bool, optional): Used for testing whether the Development schema provided is backwards compatible, or not, with the publish schema provided by the user to be upgraded. If schema compatibility fails, an exception would be thrown else the call would succeed. This parameter is optional and defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.clouddirectory.published_schema.init.upgrade(
                ctx, development_schema_arn=value, published_schema_arn=value, minor_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.clouddirectory.published_schema.init.upgrade development_schema_arn=value, published_schema_arn=value, minor_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="clouddirectory",
        operation="upgrade_published_schema",
        op_kwargs={
            "DevelopmentSchemaArn": development_schema_arn,
            "PublishedSchemaArn": published_schema_arn,
            "MinorVersion": minor_version,
            "DryRun": dry_run,
        },
    )
